
//-----------------------------------------------------------------------
//  LEZIONE 1
//
/*
  28/01/2019, Copyright (c) 2019 SCUOLA PROFESSIONALE L. EINAUDI
  Beta
-----------------------------------------------------------------------
*/
#include "mbed.h"
#include "button_group.hpp"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

Serial pc(USBTX, USBRX);


LCD_DISCO_F746NG lcd_;
TS_DISCO_F746NG ts_;

const uint32_t BACK_COLOR = 0xFF006A6C; 


void screen_setup_menu(void)
{
    using namespace Mikami;
    lcd_.Clear(LCD_COLOR_DARKBLUE);
    const string FIRST_CHOICE[9] = {"DISPLAY PARAMETERS","WiFi", "MACHINE NUMBER","BASE PRESSURE","SCREEN SUSPENSION","SETUP LITERS","WATER PRESSURE","SETUP ALARMS","RETURN"};
    const string FIRST_CHOICE1[9] = {" ", " ", " "," "," "," "," "," "," "};
    ButtonGroup menu_schadow(lcd_, ts_, 18, 17, 220, 40,
                             LCD_COLOR_BLACK, LCD_COLOR_DARKBLUE, 9, FIRST_CHOICE1, 10, 10, 2, Font16);
    ButtonGroup menu(lcd_, ts_, 16, 15, 220, 40,
                     BACK_COLOR, LCD_COLOR_DARKBLUE, 9, FIRST_CHOICE, 10, 10, 2, Font16);



    bool exitFromLoop = false;
    while (!exitFromLoop) {
        if (menu.Touched(8, LCD_COLOR_GREEN)) {
            wait(0.2);
            lcd_.Clear(BACK_COLOR);
 
            //writeFlash();
            
            exitFromLoop=true;
        } else if (menu.Touched(0, LCD_COLOR_GREEN)) {
            exitFromLoop=true;
        } else if (menu.Touched(1, LCD_COLOR_GREEN)) {
            exitFromLoop=true;
        } else if (menu.Touched(2, LCD_COLOR_GREEN)) {
            exitFromLoop=true;
        } else if (menu.Touched(3, LCD_COLOR_GREEN)) {
            exitFromLoop=true;
        } else if (menu.Touched(4, LCD_COLOR_GREEN)) {
            exitFromLoop=true;
        } else if (menu.Touched(5, LCD_COLOR_GREEN)) {
            exitFromLoop=true;
        } else if (menu.Touched(6, LCD_COLOR_GREEN)) {
            exitFromLoop=true;
        }
        
        
        
        wait(0.2);

    }
    return;
}

void init_lcd(void)
{
    lcd_.Clear(LCD_COLOR_WHITE);
    pc.printf("********** start INIT_LCD *********\n");
    lcd_.SetBackColor(LCD_COLOR_WHITE);
    lcd_.SetTextColor(LCD_COLOR_BLACK);
    lcd_.DisplayStringAt(0, LINE(1), (uint8_t *)"LEZIONE 1", CENTER_MODE);

    wait(1.5);

    lcd_.Clear(LCD_COLOR_BLACK);
    lcd_.SetBackColor(LCD_COLOR_BLACK);
    lcd_.SetTextColor(LCD_COLOR_WHITE);
    lcd_.SetFont(&Font16);
    lcd_.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);

    wait(0.5);
    lcd_.SetFont(&Font16);
    screen_setup_menu();
}




int main()
{
    pc.baud(115200);
    pc.printf("START...\n");
    //wait(2000);
    init_lcd();   // inizializzazione lcd e touch screen
    lcd_.SetFont(&Font16);
    //wait(2000);
    screen_setup_menu();
}



