/*******************************************************************************
 Project : Aru Master
 Version : 1.2.0
 *******************************************************************************/
#include "mbed.h"
#include "C027_api.h"
#include "AruFraming.h"
#include "AruChannel.h"
#include "DataProcess.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
//#include "RtuRpc.h"
#include "Modem.h"
#include "MDM.h"
#include "modeldata.h"
#include <sstream>

//------------------------------------------------------------------------------
//  Pin Init
//------------------------------------------------------------------------------
DigitalOut      led(LED); // Status Led
Serial          dbg(USBTX, USBRX); // Serial to PC
Serial          sock(D1, D0); // Aru Master Line
DigitalOut pin(MDMPWRON, 0);
DigitalOut led1(D9, 0), led2(D8, 0), led3(D7, 0);

//------------------------------------------------------------------------------
//  Variable Init
//------------------------------------------------------------------------------
std::vector<int> RCV_BUFF;   // temporary buffer receiving progress
int timerRxTOutCnt;
bool AruReqTick;
bool tmr10msTick;
bool PriSnd; // true = primary, false = secondary
bool SendNow;
int steptelegram;
int itung;
bool SkadaTask;

//------------------------------------------------------------------------------
//  Function Init
//------------------------------------------------------------------------------
//RtuRpc cmd("180.235.151.2");

//------------------------------------------------------------------------------
// Serial Interrupt
void rxInterupt()
{
    RCV_BUFF.push_back(sock.getc());
    timerRxTOutCnt = 0;   
}

//------------------------------------------------------------------------------
//  FTL protocol handling
//
AruChannel ARU;
    
//------------------------------------------------------------------------------
//  Aru pooling mechanism
//
Ticker timerAru;
void timerAruTick();
    
//------------------------------------------------------------------------------
// Mechanism timer 10ms for all
// 
Ticker timer10ms;
void timer10msTick()
{
    tmr10msTick = true;
}

//------------------------------------------------------------------------------
// Blinking
// 
Ticker timer1s;
void timer1sTick()
{
    led = !led;
    led1 = !led1;
}

//------------------------------------------------------------------------------
// Data Processing
//
DataProcess Data;

//------------------------------------------------------------------------------
//  Main Program
//------------------------------------------------------------------------------
int main() 
{   
//     Clear MODBUS Timers
    tmr10msTick = false;
    AruReqTick = false;
    PriSnd = true;
    SendNow = false;
    SkadaTask = SKADA;

    dbg.baud(9600);    
    dbg.format(8,SerialBase::None,1);
        
    sock.baud(9600);
    sock.format(8,SerialBase::None,1);
    
    printf("\r\n<Setup is OK>\r\n");
    Net::poll();
    
    dbg.printf("<main>\r\n");

    sock.attach(rxInterupt);
    timerRxTOutCnt = 0;
    
    dbg.printf("<Modem Created>\r\n");
    MDMSerial mdm;
    SetModem(mdm);
    
    timerAru.attach(&timerAruTick, 8);
    timer10ms.attach_us(&timer10msTick, 10000);

    timer1s.attach(&timer1sTick,1);
    
    steptelegram = 0;
    itung = 0;

    while(1) 
    {
        Net::poll();
        
        if(tmr10msTick)
        {
            tmr10msTick = false;
            ARU.Tick10ms();
        }
        
        if(AruReqTick)
        {
            AruReqTick = false;
            
            if(PriSnd)
            {
                Eot r('E', TelegramState[steptelegram]);
                ARU.Transmit(r);
            }
            else
            {
                Eot r('I', TelegramState[steptelegram]);
                ARU.Transmit(r);
            }
            PriSnd = !PriSnd;
            dbg.printf("\r\n<Start Send Querry with step %d>\n\r", steptelegram);
        }

        ARU.Process();

        if(ARU.ReceiveCount() > 0)
        {
            led2 = 1;
            dbg.printf("\r\n<Receive Data>\n\r");
            
            AruFrm mf = ARU.Receive();
            
            dbg.printf("Identifier : %c\r\n", mf.Identifier);
            dbg.printf("Data input :\r\n");
            unsigned int sz = mf.Data.size();
            dbg.printf("%c", mf.Identifier);
            for(unsigned int i=0; i<sz; i++)
            {
                dbg.printf("%c", mf.Data[i]);
            }
            dbg.printf("\r\n");
            Data.CheckFtlMassage('E', mf);
            
            if(Data.getFtlMessage() == FtlMessage::OK)
            {
                Data.CheckDtMassage(mf);
                if(Data.getDtMessage() == DataMessage::OK)
                {
                    switch(steptelegram)
                    {
                        case 0 : /*Order_state*/
                        {
                            DataProcess::STATE st = Data.checkOrderState();
                            
                            if(st == Data.NOORDER)
                            {
                                dbg.printf("No Order Present\r\n");
                            }
                            else if(st == Data.ORDERRCV)
                            {
                                dbg.printf("Order Receive\r\n");
                            }
                            else if(st == Data.PLANORDERPROC)
                            {
                                dbg.printf("Order Process\r\n");
                                steptelegram = 1;
                            }
                            else if(st == Data.UNPLANORDERPROC)
                            {
                                dbg.printf("Order Process\r\n");
                                steptelegram = 1;
                            }
                            else if(st == Data.ORDERFINERROR)
                            {
                                dbg.printf("Order Finish with error\r\n");
                            }
                            else if(st == Data.ORDERFINNOERROR)
                            {
                                dbg.printf("Order Finish without error\r\n");
                            }
                            SendNow = true;
                            SkadaTask = SKADA;
                            break;
                        }
                        case 1 : /* Interlock */
                        {
                            DataProcess::STATE st = Data.chackInterlock();
                            if(st == Data.ACCCLOSED)
                            {
                                dbg.printf("Access is closed, please wait\r\n");
                            }
                            else if(st == Data.ACCOPEN)
                            {
                                dbg.printf("Access is opened, goto meter_state\r\n");
                                steptelegram = 2;
                                SendNow = true;
                                SkadaTask = SKADA;
                            }
                            break;
                        }
                        case 2 : /*Meter_state*/
                        {
                            DataProcess::STATE st = Data.checkState();
                            
                            if(st == Data.STEPDOWN)
                            {
                                dbg.printf("STEPDOWN\r\n");
                            }
                            else if(st == Data.STEPUP)
                            {
                                dbg.printf("STEPUP\r\n");
                            }
                            else if(st == Data.STEPJUMP)
                            {
                                dbg.printf("STEP LONCAT\r\n");
                            }
                            else if(st == Data.STEPEND)
                            {
                                dbg.printf("JUMP TO END\r\n");
                                steptelegram = 3;
                            }
                            else if(st == Data.STAY)
                            {
                                dbg.printf("STEP TETAP\r\n");
                            }
                            else if(st == Data.FINISH)
                            {
                                dbg.printf("FINISH\r\n");
                                steptelegram = 3;
                            }
                            else if(st == Data.STAYNOL)
                            {
                                dbg.printf("STEP TETAP DI NOL\r\n");
                                itung++;
                                if(itung > 10)
                                {
                                    itung = 0;
                                    steptelegram = 0;
                                }
                            }
                            else if(st == Data.ERROR)
                            {
                                dbg.printf("STEP ERROR COY\r\n");
                                steptelegram = 6; // error querry
                            }
                            else
                            {
                                dbg.printf("STEP GA NORMAL\r\n");
                            }
                            SendNow = true;
                            SkadaTask = SKADA;
                            break;
                        }
                        case 3 : 
                        {
                            steptelegram = 4;
                            SendNow = true;
                            SkadaTask = TASK;
                            break;
                        }
                        case 4 :
                        {
                            steptelegram = 0;
                            SendNow = true;
                            SkadaTask = TASK;
                            break;
                        }
                        case 5 :
                        {
                            SendNow = true;
                            SkadaTask = TASK;
                            break;
                        }
                        case 6 :
                        {
                            steptelegram = 0;
                            SendNow = true;
                            SkadaTask = TASK;
                            break;
                        }
                        default: break;
                    }
                }
                else
                {
                    dbg.printf("Data Ditolak\r\n");
                    steptelegram = 0;
                }
                    
                if(chekConect(mdm) && SendNow)
                {
                    SendNow = false;
                    
                    if(PostData(mdm, mf.Identifier, mf.Data, SkadaTask))
                    {
                        dbg.printf("Data Berhasil dikirim\r\n");
                    }
                    else
                    {
                        dbg.printf("Gagal Kirim Data\r\n");
                    }
                }
            }
            else if(Data.getFtlMessage() == FtlMessage::PROERROR)
            {
                dbg.printf("Protokol Error GAN!!!\r\n");
                steptelegram = 0;
            }
            else
            {
                dbg.printf("Balasan Tidak sesuai coy!!!\r\n");
                steptelegram = 0;
            }
            led2 = 0;
        }
    } // akhir while(1)
}// akhir main

//-------------------------------------------------------------------
void timerAruTick()
{    
    AruReqTick = true;
}
//-------------------------------------------------------------------
