#include "LidarLitev2.h"
#include "DRV8825.h"
#include "MODSERIAL.h"
#include "math.h"

#define PI 3.14159265359

Serial pc(USBTX, USBRX);

DRV8825 stpr_mtr(p21, p22, p23, p24, p25, p26);
DigitalIn pinMode(p19); 

LidarLitev2 Lidar(p28, p27);


int main()
{   
    stpr_mtr.direction = 1;
    pc.baud(9600);
    Lidar.configure();
    //Lidar.beginContinuous();
    float degree = 0, x, y;
    int distance;
    char e;
    while(1){
         if(pc.readable()) {
             e = pc.getc();
        }
        while (e == 'e'){
         //if(!pinMode) {  //Check if the lidar is pulling low
            distance = Lidar.distance();
            x = distance*cos(degree*(PI/180));
            y =  distance*sin(degree*(PI/180));
            stpr_mtr.settings(1, 0, 400);
            degree += .45;
            if(degree >= 360) degree = 0;
            //pc.printf("%4d,%4.0f\n", distance, degree);
            pc.printf("%4.0f,%4.0f\n", x, y);
          //}
          if(pc.readable()) {
             e = pc.getc();
            }
          if (e == 's') break;
        }
    }
}