/*Código escrito por Marcelo Costanzo Miranda
*Projeto feito conforme pedido do professor Silvio Szafir 
*
* Placa ST discovery com display ePaper funcionando como LCD 20x4
*
*   São Paulo, SP
*    30 de agosto de 2018
*
*/

#include "mbed.h"
#include "EPD_GDE021A1.h"



#define EPD_CS       PA_15
#define EPD_DC       PB_11
#define EPD_RESET    PB_2
#define EPD_BUSY     PA_8
#define EPD_POWER    PB_10
#define EPD_SPI_MOSI PB_5
#define EPD_SPI_MISO PB_4
#define EPD_SPI_SCK  PB_3

EPD_GDE021A1 epd(EPD_CS, EPD_DC, EPD_RESET, EPD_BUSY, EPD_POWER, EPD_SPI_MOSI, EPD_SPI_MISO, EPD_SPI_SCK);

DigitalOut led1(LED1);
DigitalIn button(PA_0);
Ticker flipper;
Serial pc(USBTX, USBRX); // tx, rx

//width 48
//height 26

static uint8_t Battery_img[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x18, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0xff, 0x39, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x10, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x38, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x18, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x08, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0x3f, 0x00, 0x0c, 
0xfe, 0xff, 0xff, 0xff, 0xff, 0x0f, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
};

void flip() 
{
    led1=!led1;  
}

uint16_t x=0, y=0, i=0;
char c, c1, c2;
char s[100];


int main()
{

    flipper.attach(&flip, 0.1);//interrupção para piscar o led, debug para saber se o uC travou
    
    
    //mensagens de boas vindas
    epd.Clear(EPD_COLOR_WHITE);  
    epd.DisplayStringAtLine(5, (uint8_t*)"MBED", CENTER_MODE);
    epd.DisplayStringAtLine(3, (uint8_t*)"Epaper display", LEFT_MODE);
    epd.DisplayStringAtLine(2, (uint8_t*)"demo", LEFT_MODE);
    epd.DrawImage(130, 0, 48, 26, Battery_img);
    epd.DrawRect(50, 4, 60, 4);
    epd.RefreshDisplay();
    wait(1);
    epd.Clear(EPD_COLOR_WHITE);  
    epd.RefreshDisplay();
    epd.Clear(EPD_COLOR_WHITE); 
    
    
    epd.SetFont(&Font16);
    while(1)
    {
       
//----------ROTINA PARA ESCREVER NO EPAPER------------------------   

        pc.printf("\nEscolha a linha Y, de 0 a 3:");  
        c = pc.getc();
        switch (c)
                {
                    case '3': y = 0;break;
                    case '2': y = 4;break;
                    case '1': y = 8;break;
                    case '0': y = 12;break;
                }
        pc.printf("\n%u",y);
        
        pc.printf("\nEscolha a coluna X, de 00 a 19:");  
        c1 = pc.getc(); 
        c2 = pc.getc();   
        switch (c2)
                {
                    case '0': x = 0;break;
                    case '1': x = 1;break;
                    case '2': x = 2;break;
                    case '3': x = 3;break;
                    case '4': x = 4;break;
                    case '5': x = 5;break;
                    case '6': x = 6;break;
                    case '7': x = 7;break;
                    case '8': x = 8;break;
                    case '9': x = 9;break;
                } 
           
        switch (c1)
                {
                    case '0': x = x + 0;break;
                    case '1': x = x + 10;break;
                    
                }    
                
                x = x * 10;
        pc.printf("\n%u",x);
            
            pc.printf("\nEntre com seu texto (com # no final):");
            
           do
           {
               c = pc.getc();
               s[i] = c;
               ++i;
            }
            while(c!='#'); //entra em loop, coletando os caracteres até achar o #, e então sai do loop
            
            s[i-1] = '\0';   //elimina o caracter terminador de strings
            pc.printf("%s", s);
            for(int o = 0; o < i - 1; o++)
            {
                epd.DisplayChar(x, y,s[o]);
                x = x + 10;
            }
            epd.RefreshDisplay();
            i=0;

        //FIM DA ROTINA PARA ESCREVER NO EPAPER 
            
    }//FIM DA WHILE
}//FIM DO PROGRAMA