

#include "TextLCD.h"
#include "mbed.h"


AnalogIn tensao(A5);



Serial pc(USBTX, USBRX);

float v_lido ; // Variável que recebe o valor de tensão

TextLCD lcd(D8, D9, D4, D5, D6, D7);

int main()

{
    
    lcd.setBacklight(TextLCD::LightOn); // Habilita a função Backlight

    while(1)

    {

        v_lido= tensao;
        
        v_lido = (v_lido*3.32f)*3.3f;                    // Valor 3.2 é a relação da tensão da bateia 9.4 V
                                                      // com a tensão que foi calculada no divisor de tensão que é 3
        pc.printf("\n\r%1.f ",v_lido);              // Envia Dados da variável v_lido para a serial
       // wait_ms(50);

        lcd.setAddress(0,0);                        // Informa a posição que a mensagem será exibida no display LCD

        lcd.printf("Tensao:");

        lcd.setAddress(8,0);

        lcd.printf("%1.2f \n\r",v_lido);       // Envia Dados da variável v_lido para o LCD
        wait(1);

        lcd.setAddress(13,0);

        lcd.printf("V");
        
        lcd.setAddress(0,0);
        
        lcd.printf(" ");
    }
}