#include "mbed.h"
#include "TextLCD.h"
//**************************Declara uso da serial*******************************
Serial pc(USBTX, USBRX); // tx, rx

//**************************Declara uso da CAN**********************************
CAN can1(PB_8, PB_9);

//**************Declara uso do LED nativo da placa*******************************
DigitalOut LED(PA_5);

//****************Declara uso do botao nativo da placa***************************
DigitalIn SW(PC_13);
//*******************Declaração dos Pinos LCD************************************
TextLCD lcd(D8, D9, D4, D5, D6, D7); // rs, e, d4-d7

//----------Pinos de entrada analogica (ADC)------
AnalogIn   AXIS_X(A0);
AnalogIn   AXIS_Y(A1);

//***********Dado da mensagem chamada de info que sera usada********************
static char righ =  0x55;
static char left =  0x35;

int main()
{
//*****construção da mensagem CAN (ID, dado, tamanho em bits, Tipo de dado, Modo CAN)****
    CANMessage msg_right(5, &righ, 8, CANData, CANStandard);
    CANMessage msg_left(5, &left, 8, CANData, CANStandard);
    //****************************************************************************

    //*******************pisca o led********************************************
    LED = 1;
    wait(0.5);
    LED = 0;
    wait(0.5);



    lcd.setAddress(0,0);                        // Informa a posição que a mensagem será exibida no display LCD

    lcd.printf("Potenciometro");

    float VAL_X = 0.0f, VAL_Y = 0.0f;

    while(1) {

//*******************Leitura do joystick nos eixos X e Y ***********************

        VAL_X = AXIS_X.read();
        VAL_Y = AXIS_Y.read();

//******************************************************************************

         pc.printf(" %1.2f VAL_Y %x\n\r", VAL_Y);
         wait(0.5);
         

        if(VAL_Y > 0.3f) {
            if(can1.write(msg_right)) {
                lcd.setAddress(0,0);
                lcd.printf("Direita ");
            }

            else {
                lcd.printf("Direita NAO enviada\n");
            }
        }

        //----Envia mensagem para -Y -----
        if(VAL_Y < 0.3f) {
            //printf("\n\rLEFT");
            if(can1.write(msg_left)) {
                lcd.setAddress(0,0);
                lcd.printf("Esquerda enviada\n");
            }

            else {
                //pc.printf("Esquerda NAO enviada\n");
            }
        }

        //msg.data[0] = 0x00;

    }

}
