#include "mbed.h"
#include "codes.h"
#include "TextLCD.h"

TextLCD lcd(D8, D9, D4, D5, D6, D7); // rs, e, d4-d7

DigitalOut myled(LED1);

//Serial pc(USBTX,USBRX);

Serial device(PA_11, PA_12);

AnalogIn BUTTON_ADC(A0);

Ticker flipper;


void flip(void);
void OBDInit(void);
void read_serial(void);

void ask_intake_pressure_absolute(void);
void ask_engine_coolant_temperature(void);
void ask_engine_rpm(void);
void ask_vehile_speed(void);
void ask_intake_air_temperature(void);
void ask_throttle_position(void);
void ask_oxygen_sensor(void);
void ask_fuel_rail_pressure(void);

char RESPONSE_INTAKE_PRESSURE_ABSOLUTE[64];
char RESPONSE_ENGINE_COOLANT_TEMPERATURE[64];
char RESPONSE_ENGINE_RPM[64];
char RESPONSE_VEHILE_SPEED[64];
char RESPONSE_INTAKE_AIR_TEMPERATURE[64];
char RESPONSE_THROTTLE_POSITION[64];
char RESPONSE_OXYGEN_SENSOR[64];
char RESPONSE_FUEL_RAIL_PRESSURE[64];

char c[64];

float INTAKE_PRESSURE_ABSOLUTE;
int ENGINE_RPM;
int VEHILE_SPEED;
int INTAKE_AIR_TEMPERATURE;
int ENGINE_COOLANT_TEMPERATURE;
float THROTTLE_POSITION;
float SHORT_TERM_FUEL_TRIM;
float OXYGEN_SENSOR;
float FUEL_RAIL_PRESSURE;

int main() 
{
    flipper.attach(&flip, 1.0);
    //pc.baud(115200);

    lcd.setCursor(TextLCD::CurOff_BlkOff);      
    lcd.locate (0,0);            
    lcd.printf ("Starting up"); 

    //pc.printf("OBD STM32 v1.1.002");
    //pc.printf("\r\n");
    
    device.baud(57600);
    OBDInit();
    
    //pc.printf("OBD Inicializado");
    //pc.printf("\r\n");
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("OBD Inicializado");
    
    wait_ms(1500);
    lcd.cls();
    
    int FREQ = 1000;   
    int BUTTON;
       
    while(1) 
    {
        if ((BUTTON_ADC * 3.3) < 3.10)  BUTTON = 4; //pc.printf("SELECT\n\r");
        if ((BUTTON_ADC * 3.3) < 1.95)  BUTTON = 3; //pc.printf("LEFT\n\r");
        if ((BUTTON_ADC * 3.3) < 1.23)  BUTTON = 2; //pc.printf("DOWN\n\r");
        if ((BUTTON_ADC * 3.3) < 0.50)  BUTTON = 1; //pc.printf("UP\n\r");
        if ((BUTTON_ADC * 3.3) < 0.20)  BUTTON = 0; //pc.printf("RIGHT\n\r");   
        
        if(BUTTON == 0)
        {
            lcd.cls();
            ask_engine_rpm();
            lcd.locate(0,0);
            lcd.printf("%04i   RPM",ENGINE_RPM);
            wait_ms(FREQ);
        
            ask_engine_coolant_temperature();
            lcd.locate(1,0);
            lcd.printf("%04i  C",ENGINE_COOLANT_TEMPERATURE);
            wait_ms(FREQ);
        }
        
        if(BUTTON == 1)
        {
            lcd.cls();
            ask_intake_pressure_absolute();
            lcd.locate(0,0);
            lcd.printf("%+03.2f  bar",INTAKE_PRESSURE_ABSOLUTE);
            wait_ms(FREQ);
        
            ask_vehile_speed();
            lcd.locate(1,0);
            lcd.printf("%03i    Km/h",VEHILE_SPEED);
            wait_ms(FREQ);
        }
        
        if(BUTTON == 2)
        {
            lcd.cls();
            ask_intake_air_temperature();
            lcd.locate(0,0);
            lcd.printf("%03i    C",INTAKE_AIR_TEMPERATURE);
            wait_ms(FREQ);
        
            ask_throttle_position();
            lcd.locate(1,0);
            lcd.printf("%05.2f  pc",THROTTLE_POSITION);
            wait_ms(FREQ);
        }
        
        if(BUTTON == 3)
        {
            lcd.cls();
            ask_oxygen_sensor();
            lcd.locate(0,0);
            lcd.printf("%04.3f  mV",OXYGEN_SENSOR);
            wait_ms(FREQ);
        
            ask_fuel_rail_pressure();
            lcd.locate(1,0);
            lcd.printf("%06.2f bar",FUEL_RAIL_PRESSURE);
            wait_ms(FREQ);
        }
    }
}

void flip() 
{
    myled = !myled;
}

void ask_intake_pressure_absolute()
{
    int i = 0;
    
    device.printf(PID_INTAKE_PRESSURE_ABSOLUTE);
    device.printf(CR);
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(RESPONSE_INTAKE_PRESSURE_ABSOLUTE[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        RESPONSE_INTAKE_PRESSURE_ABSOLUTE[i] = device.getc();
        i++;
    } 
    
    char DATA_A[2];
    char DATA_B[2];
    char DATA_C[2];
    char DATA_D[2];
        
    DATA_A[0]  = RESPONSE_INTAKE_PRESSURE_ABSOLUTE[i-3];
    DATA_A[1] = RESPONSE_INTAKE_PRESSURE_ABSOLUTE[i-2];
     
    int VAL_A = strtol(DATA_A,NULL,16);   
    
    //pc.printf("%i\r",VAL_A);
        
    INTAKE_PRESSURE_ABSOLUTE = (VAL_A * 0.01f) - 1.0f;
    
    //pc.printf("pressao %i\r",INTAKE_AIR_TEMPERATURE);
    
    //for(int j = 0; j < i; j++)
    //{ 
     //pc.printf("%c",RESPONSE_INTAKE_PRESSURE_ABSOLUTE[j]);
    //}
}

void ask_engine_rpm()
{
    int i = 0;
    
    device.printf(PID_ENGINE_RPM);
    device.printf(CR);
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(RESPONSE_ENGINE_RPM[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        RESPONSE_ENGINE_RPM[i] = device.getc();
        i++;
    } 
    
    char DATA_A[2];
    char DATA_B[2];
    char DATA_C[2];
    char DATA_D[2];
        
    DATA_A[0]  = RESPONSE_ENGINE_RPM[i-5];
    DATA_A[1] = RESPONSE_ENGINE_RPM[i-4];
     
    DATA_B[0]  = RESPONSE_ENGINE_RPM[i-3];
    DATA_B[1] = RESPONSE_ENGINE_RPM[i-2];
    
    int VAL_A = strtol(DATA_A,NULL,16);   
    int VAL_B = strtol(DATA_B,NULL,16);  
    
    //pc.printf("%i\r",VAL_A);
    //pc.printf("%i\r",VAL_B);   
    
    ENGINE_RPM = ((VAL_A * 256) + VAL_B) / 4;
    
    //pc.printf("rpm %i\r",ENGINE_RPM);
    
    //for(int j = 0; j < i; j++)
    //{ 
        //pc.printf("%c",RESPONSE_ENGINE_RPM[j]);
    //}
}

void ask_vehile_speed()
{
    int i = 0;
    
    device.printf(PID_VEHILE_SPEED);
    device.printf(CR);
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(RESPONSE_VEHILE_SPEED[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        RESPONSE_VEHILE_SPEED[i] = device.getc();
        i++;
    } 
        
    char DATA_A[2];
    char DATA_B[2];
    char DATA_C[2];
    char DATA_D[2];
            
    DATA_A[0]  = RESPONSE_VEHILE_SPEED[i-3];
    DATA_A[1] = RESPONSE_VEHILE_SPEED[i-2];
    
    int VAL_A = strtol(DATA_A,NULL,16);   
    
    //pc.printf("%i\r",VAL_A);
           
    VEHILE_SPEED = VAL_A;
    
    //pc.printf("%i kmh\r",VEHILE_SPEED);
    
    //for(int j = 0; j < i; j++)
    //{ 
        //pc.printf("%c",RESPONSE_VEHILE_SPEED[j]);
    //}
}

void ask_intake_air_temperature()
{
    int i = 0;
    
    device.printf(PID_INTAKE_AIR_TEMPERATURE);
    device.printf(CR);
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(RESPONSE_INTAKE_AIR_TEMPERATURE[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        RESPONSE_INTAKE_AIR_TEMPERATURE[i] = device.getc();
        i++;
    } 
    
    char DATA_A[2];
    char DATA_B[2];
    char DATA_C[2];
    char DATA_D[2];
        
    DATA_A[0]  = RESPONSE_INTAKE_AIR_TEMPERATURE[i-3];
    DATA_A[1] = RESPONSE_INTAKE_AIR_TEMPERATURE[i-2];
     
    int VAL_A = strtol(DATA_A,NULL,16);   
    
    //pc.printf("%i\r",VAL_A);
        
    INTAKE_AIR_TEMPERATURE = VAL_A - 40;
    
    //pc.printf("temp ar %i\r",INTAKE_AIR_TEMPERATURE);
    
    //for(int j = 0; j < i; j++)
    //{ 
        //pc.printf("%c",RESPONSE_INTAKE_AIR_TEMPERATURE[j]);
    //}
}

void ask_engine_coolant_temperature()
{
    int i = 0;
    
    device.printf(PID_ENGINE_COOLANT_TEMPERATURE);
    device.printf(CR);
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(RESPONSE_ENGINE_COOLANT_TEMPERATURE[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        RESPONSE_ENGINE_COOLANT_TEMPERATURE[i] = device.getc();
        i++;
    } 
    
    char DATA_A[2];
    char DATA_B[2];
    char DATA_C[2];
    char DATA_D[2];
        
    DATA_A[0]  = RESPONSE_ENGINE_COOLANT_TEMPERATURE[i-3];
    DATA_A[1] = RESPONSE_ENGINE_COOLANT_TEMPERATURE[i-2];
     
    int VAL_A = strtol(DATA_A,NULL,16);   
    
    //pc.printf("%i\r",VAL_A);
        
    ENGINE_COOLANT_TEMPERATURE = VAL_A - 40;
    
    //pc.printf("temp ar %i\r",INTAKE_AIR_TEMPERATURE);
    
    //for(int j = 0; j < i; j++)
    //{ 
        //pc.printf("%c",RESPONSE_INTAKE_AIR_TEMPERATURE[j]);
    //}
}

void ask_throttle_position()
{
    int i = 0;
    
    device.printf(PID_THROTTLE_POSITION);
    device.printf(CR);
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(RESPONSE_THROTTLE_POSITION[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        RESPONSE_THROTTLE_POSITION[i] = device.getc();
        i++;
    } 
    
    char DATA_A[2];
    char DATA_B[2];
    char DATA_C[2];
    char DATA_D[2];
        
    DATA_A[0]  = RESPONSE_THROTTLE_POSITION[i-3];
    DATA_A[1] = RESPONSE_THROTTLE_POSITION[i-2];
     
    int VAL_A = strtol(DATA_A,NULL,16);   
    
    //pc.printf("%i\r",VAL_A);
        
    THROTTLE_POSITION = 100.0f/255.0f;
    THROTTLE_POSITION = THROTTLE_POSITION * VAL_A;
    
    //pc.printf("tbi %.2f\r",THROTTLE_POSITION);
    
    //for(int j = 0; j < i; j++)
    //{ 
        //pc.printf("%c",RESPONSE_THROTTLE_POSITION[j]);
    //}
}

void ask_oxygen_sensor()
{
    int i = 0;
    
    device.printf(PID_OXYGEN_SENSOR);
    device.printf(CR);
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(RESPONSE_OXYGEN_SENSOR[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        RESPONSE_OXYGEN_SENSOR[i] = device.getc();
        i++;
    } 
    
    char DATA_A[2];
    char DATA_B[2];
    char DATA_C[2];
    char DATA_D[2];
        
    DATA_A[0]  = RESPONSE_OXYGEN_SENSOR[i-5];
    DATA_A[1] = RESPONSE_OXYGEN_SENSOR[i-4];
     
    DATA_B[0]  = RESPONSE_OXYGEN_SENSOR[i-3];
    DATA_B[1] = RESPONSE_OXYGEN_SENSOR[i-2];
    
    int VAL_A = strtol(DATA_A,NULL,16);   
    int VAL_B = strtol(DATA_B,NULL,16);  
    
    //pc.printf("%i\r",VAL_A);
    //pc.printf("%i\r",VAL_B);   
    
    OXYGEN_SENSOR = VAL_A / 200.0f;
    
    SHORT_TERM_FUEL_TRIM = ((100.0f / 128.0f) * VAL_B) - 100.0f;
    
    //pc.printf("sonda %f\r",OXYGEN_SENSOR);
    //pc.printf("trim %f\r",SHORT_TERM_FUEL_TRIM);
    
    //for(int j = 0; j < i; j++)
    //{ 
        //pc.printf("%c",RESPONSE_OXYGEN_SENSOR[j]);
    //}
}

void ask_fuel_rail_pressure()
{
    int i = 0;
    
    device.printf(PID_FUEL_RAIL_PRESSURE);
    device.printf(CR);
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(RESPONSE_FUEL_RAIL_PRESSURE[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        RESPONSE_FUEL_RAIL_PRESSURE[i] = device.getc();
        i++;
    } 
    
    char DATA_A[2];
    char DATA_B[2];
    char DATA_C[2];
    char DATA_D[2];
                
    DATA_A[0]  = RESPONSE_FUEL_RAIL_PRESSURE[i-5];
    DATA_A[1] = RESPONSE_FUEL_RAIL_PRESSURE[i-4];
     
    DATA_B[0]  = RESPONSE_FUEL_RAIL_PRESSURE[i-3];
    DATA_B[1] = RESPONSE_FUEL_RAIL_PRESSURE[i-2];
    
    int VAL_A = strtol(DATA_A,NULL,16);   
    int VAL_B = strtol(DATA_B,NULL,16);   
    
    //pc.printf("%i\r",VAL_A);  
    
    FUEL_RAIL_PRESSURE = ((VAL_A * 256) + VAL_B) * 0.1f;
    
    //pc.printf("alta %f\r",FUEL_RAIL_PRESSURE);
    
    //for(int j = 0; j < i; j++)
    //{ 
        //pc.printf("%c",RESPONSE_FUEL_RAIL_PRESSURE[j]);
    //}
}

void read_serial()
{
    int i = 0;
          
    while(!device.readable()){} //fica esperando chegar algo na serial
    while(c[i-1]!= '\r')        //chegou algo! vamos ler até o CR
    {  
        c[i] = device.getc();
        //pc.printf("%c",c[i]);
        i++;
    } 
    //for(int j = 0; j < i; j++)
    //{ 
        //pc.printf("%c",c[j]);
    //}
}

void OBDInit()
{
    lcd.locate (4,0);
    lcd.printf (".");
    lcd.redraw();
    device.printf(SET_ALL_TO_DEFAULT);
    device.printf(CR);
    wait_ms(200);
    lcd.locate (4,1);
    lcd.printf (".");
    lcd.redraw();
    wait_ms(200);
                
    lcd.locate (4,2);
    lcd.printf (".");
    lcd.redraw();            
    device.printf(RESET_ALL);
    device.printf(CR);
    wait_ms(200);
    lcd.locate (4,3);
    lcd.printf (".");
    lcd.redraw();
    wait_ms(200);
    
    lcd.locate (4,4);
    lcd.printf (".");
    lcd.redraw();   
    device.printf(LINEFEED_OFF);
    device.printf(CR);
    wait_ms(200);
    lcd.locate (4,5);
    lcd.printf (".");
    lcd.redraw();
    wait_ms(200);
    
    lcd.locate (4,6);
    lcd.printf (".");
    lcd.redraw(); 
    device.printf(PRINTING_SPACES_OFF);
    device.printf(CR);
    wait_ms(200);
    lcd.locate (4,7);
    lcd.printf (".");
    lcd.redraw();
    wait_ms(200);
    
    lcd.locate (4,8);
    lcd.printf (".");
    lcd.redraw();
    device.printf(MEMORY_OFF);
    device.printf(CR);
    wait_ms(200);
    lcd.locate (4,9);
    lcd.printf (".");
    lcd.redraw();
    wait_ms(200);
    
    lcd.locate (4,10);
    lcd.printf (".");
    lcd.redraw();        
    device.printf(SET_TIMEOUT_256);
    device.printf(CR);
    wait_ms(200);
    lcd.locate (4,11);
    lcd.printf (".");
    lcd.redraw();
    wait_ms(200);
    
    lcd.locate (4,12);
    lcd.printf (".");
    lcd.redraw();    
    device.printf(TRY_PROTOCOL_0);
    device.printf(CR);
    wait_ms(200);
    lcd.locate (4,13);
    lcd.printf (".");
    lcd.redraw();
    wait_ms(200);
    
    lcd.locate (4,14);
    lcd.printf (".");
    lcd.redraw();    
    device.printf(ECHO_OFF);
    device.printf(CR);
    wait_ms(200);
    lcd.locate (4,15);
    lcd.printf (".");
    lcd.redraw();
    wait_ms(200);
    
    //device.printf("ATPP0CSV45");
    //device.printf("ATBRD45");
    //device.printf(CR);
    //wait_ms(200);
    //device.baud(57600);
    //device.printf("ATPP0CON");
    //device.printf(CR);
    //wait_ms(200);
    
    //device.printf("ATLP");
    //device.printf(CR);
    //wait_ms(200);
}