# include "mbed.h"

AnalogIn pot(A0);
InterruptIn Pulso(D7);
DigitalOut scr   (D8);
Serial pc(USBTX,USBRX);

int x,temp = 0;

void interrupt ()
{
        wait_us(temp);                              //Delay para o disparo (angulo)
        scr = 1;
        wait(0.0015);                                   //Largura do pulso de disparo (15ms)
        scr = 0;
}

int main()
{
    Pulso.rise(&interrupt);
    Pulso.fall(&interrupt);

    while(1) {
        x=pot.read()*255;                               //Converte uma leitura do ADC em float para formato int e armazena na variável x.
        temp = x*26;

        pc.printf("\rValor Pot=\t%d \t%2.3fV\t%d us    \t ",x,pot.read(),temp);
        
        wait(0.01);
    }
}
