/*
Autor Marcelo Costanzo Miranda
Data 08 de Outubro de 2018

Codigo base para robo seguir de linha, funcionando

Insper, Laboratório de Sistema Mecatrôncios
*/

#include "mbed.h"
#define corte 0.3f

AnalogIn S0(A3);
AnalogIn S1(A5);
DigitalIn BT(BUTTON1);
DigitalOut led(LED1);
DigitalOut IN1B(PA_0);
DigitalOut IN2B(PA_1);
DigitalOut IN1A(PB_4);
DigitalOut IN2A(PB_5);
PwmOut ENA(PA_10);
PwmOut ENB(PB_3);
Serial pc(USBTX, USBRX); // tx, rx


int main()
{
    float S0_val = 0;
    float S1_val = 0;
    bool flag = 0;
    
    ENA = 0.12f;
    ENB = 0.12f;

    while(1) 
    {
        
        
        S0_val = S0.read();
        S1_val = S1.read(); 
        
        //S0_val = S0_val * 3300; // Converts value in the 0V-3.3V range
        //S1_val = S1_val * 3300; // Converts value in the 0V-3.3V range
        
        // Display values
        //printf("measure S0 = %.0f mV\n", S0_val);
        //printf("measure S1 = %.0f mV\n", S1_val);
        
        if(BT == 0)
        {
            wait(0.1);
            if(BT == 0 && flag == 0)
            {
                flag = 1;
                led = 1;
                wait(0.5);
            }
        }
        
        if(flag == 0)
        led = 0;
        
        if(flag == 1)
        {
            //printf("ACIONADO\n");
            if((S0_val > corte) && (S1_val > corte))
            {
                IN2A = 0;
                IN2B = 0;
                IN1A = 0;
                IN1B = 0;
            }
            
            if((S0_val < corte) && (S1_val < corte))
            {
                IN2A = 1;
                IN2B = 0;
                IN1A = 0;
                IN1B = 1;
            }
            
            if((S0_val < corte) && (S1_val > corte))
            {
                IN2A = 0;
                IN2B = 0;
                IN1A = 0;
                IN1B = 1;
            }
            
            if((S0_val > corte) && (S1_val < corte))
            {
                IN2A = 1;
                IN2B = 0;
                IN1A = 0;
                IN1B = 0;
            }
        }
        
        if(BT == 0)
        {
            wait(0.1);
            if(BT == 0 && flag == 1)
            {
                flag = 0;
                printf("DESACIONADO\n");
                ENA = 0.0f;
                ENB = 0.0f;
                wait(0.5);
            }
        }        

        //wait(0.2); // 1 second
    }
}
