#include "mbed.h"

#define CW      0
#define CCW     1
#define BRAKED  2
#define HIGH_Z  3

//---Pinos de enable dos braços----
DigitalOut enable_ch1(PC_10);
DigitalOut enable_ch2(PC_11);
DigitalOut enable_ch3(PC_12);

//---Pinos de canais dos braços----
PwmOut in_ch1(PA_8);
PwmOut in_ch2(PA_9);
PwmOut in_ch3(PA_10);

//---Pino de ADC da X-NUCLEO ----
AnalogIn pot(PB_1);

//---Pino do led da NUCLEO----
DigitalOut myled(LED1);

//---Pino do butao da NUCLEO----
DigitalIn sw(PC_13);

//---Pinos do serial-USB da NUCLEO----
Serial pc(USBTX, USBRX);

//---Prototipo das Funções----
void bridge(float DUTY, unsigned int DIRECTION);

//---Programa principal-------
int main() 
{
    //---Configura o periodo do PWM----
    in_ch1.period_ms(1);
    in_ch2.period_ms(1);
    in_ch3.period_ms(1);
    
    //---Inicia o PWM com 0% de duty-cicle----
    in_ch1.write(0);
    in_ch2.write(0);
    in_ch3.write(0);
    
    //---Inicia os braços em Z (alta impedancia)----
    enable_ch1 = 2;
    enable_ch2 = 2;
    enable_ch3 = 2;
    
    //---Configura o baudrate da serial para 115200---
    pc.baud(115200);   
            
    pc.printf("Started\r"); //Iniciando
    
    while(1) 
    {
        pc.printf("CW\r");
        bridge(0.5, CW);
        wait_ms(5000);
        
        pc.printf("CCW\r");
        bridge(0.5, CCW);
        wait_ms(5000);
        
        pc.printf("BRAKED\r");
        bridge(0.5, BRAKED);
        wait_ms(5000);
        
        pc.printf("HIGH Z\r");
        bridge(0.5, HIGH_Z);
        wait_ms(5000);
    }
}

//---Função de controle dos braços----------
void bridge(float DUTY, unsigned int DIRECTION)
{
    //Direção for horaria
    if(DIRECTION == CW)
    {
        enable_ch1 = 1;
        in_ch1.write(DUTY);
        enable_ch2 = 1;
        in_ch2.write(0);
    }
    
    //Direção for anti horaria
    if(DIRECTION == CCW)
    {
        enable_ch1 = 1;
        in_ch1.write(0);
        enable_ch2 = 1;
        in_ch2.write(DUTY);
    }
    
    //Freiado
    if(DIRECTION == BRAKED)
    {
        enable_ch1 = 1;
        in_ch1.write(DUTY);
        enable_ch2 = 1;
        in_ch2.write(DUTY);
    }
    
    //Livre
    if(DIRECTION == HIGH_Z)
    {
        enable_ch1 = 2;
        in_ch1.write(0);
        enable_ch2 = 2;
        in_ch2.write(0);
    }
}
