#include "L6230_BLDC.h"
#include "mbed.h"
 
L6230_BLDC::L6230_BLDC(PinName en1_pin, PinName en2_pin, PinName en3_pin, PinName out1_pin, PinName out2_pin, PinName out3_pin) :
            _en1_pin(en1_pin), _en2_pin(en2_pin), _en3_pin(en3_pin), _out1_pin(out1_pin), _out2_pin(out2_pin), _out3_pin(out3_pin)
{
    _en1_pin = 0;
    _en2_pin = 0;
    _en3_pin = 0;
    _out1_pin = 0;
    _out2_pin = 0;
    _out3_pin = 0;
}

void L6230_BLDC::stop()
{  
    _out1_pin = 0; _out2_pin = 0; _out3_pin = 0;
    _en1_pin = 0; _en2_pin = 0; _en3_pin = 0; 
}
 
void L6230_BLDC::turn(bool dir, int delay_time)
{
}
 
  
void L6230_BLDC::turn_n_steps(bool dir, int delay_time, int stepNum) 
{
    /* Digital outputs are initially zero */
    _out1_pin = 0; _out2_pin = 0; _out3_pin = 0;
    
    /* Enable the outputs initially */
    _en1_pin = 1; _en2_pin = 1; _en3_pin = 1; 
    
    int stepCount = 0; // Number of step counts
    
    /* Magical data_array to drive the brushless motor */ 
    // HIGH:1, LOW:0, HIGH-Z:2
    char data_array[]={1,2,0, 1,0,2, 2,0,1, 0,2,1, 0,1,2, 2,1,0};
    char data_arrayInv[]={0,1,2, 0,2,1, 2,0,1, 1,0,2, 1,2,0, 2,1,0};
    
    if(dir==1)      // if dir = 1, reverse the motor direction
        for(int k=0; k<18; k++)
            data_array[k] = data_arrayInv[k];      
    
    for (int i=0; i<stepNum; i++)
    {
        i%=6;  // Steps will be repeated at mod6
        _out1_pin = data_array[3*i];    (data_array[3*i]   == 2)?(_en1_pin = 0):(_en1_pin = 1);   
        _out2_pin = data_array[3*i+1];  (data_array[3*i+1] == 2)?(_en2_pin = 0):(_en2_pin = 1); 
        _out3_pin = data_array[3*i+2];  (data_array[3*i+2] == 2)?(_en3_pin = 0):(_en3_pin = 1); 
        wait_us(delay_time);   
        if(++stepCount == stepNum) break;    
    }
}
 
void L6230_BLDC::one_step(bool dir, int delay_time, int* prevStep)
{
    /* Digital outputs are initially zero */
    _out1_pin = 0; _out2_pin = 0; _out3_pin = 0;
    
    /* Enable the outputs initially */
   _en1_pin = 1; _en2_pin = 1; _en3_pin = 1; 
    
    /* Magical data_array to drive the brushless motor */ 
    // HIGH:1, LOW:0, HIGH-Z:2
    char data_array[]={1,2,0, 1,0,2, 2,0,1, 0,2,1, 0,1,2, 2,1,0};
      
    if(dir==1)
        *prevStep = *prevStep + 1;    // Increase prevStep for next step || WARNING: *prevStep++ did not work
    else 
        *prevStep = *prevStep - 1; 
        
    int i = *prevStep;
        
    if (i<0)   // Mod operation for the negative number
    {
        i*=(-1); i%=6; i=6-i; 
        i%=6;  // if i=6, it should be zero.   
    }   
    else 
        i%=6;   // Steps will be repeated at mod6
    
    _out1_pin = data_array[3*i];    (data_array[3*i]   == 2)?(_en1_pin = 0):(_en1_pin = 1);   
    _out2_pin = data_array[3*i+1];  (data_array[3*i+1] == 2)?(_en2_pin = 0):(_en2_pin = 1); 
    _out3_pin = data_array[3*i+2];  (data_array[3*i+2] == 2)?(_en3_pin = 0):(_en3_pin = 1);   
    wait_us(delay_time);  
} 