// O presente programa trabalha com as entradas analógicas (A0 e A1)
// dediccadas à leitura dos potênciometros do JOYSTICK modelo MH
// (VRX = A0, VRY = A1, SW = PC_13, GND = GND, +5V = 3V3 NUCLEO)
// AFM 2021-04-07

#include "mbed.h"

DigitalIn SW(PC_13);

AnalogIn VRX(A0);
AnalogIn VRY(A1);

DigitalOut myled(LED1);
 
Serial pc(USBTX, USBRX);
 
int main() {

int i;
int x,y;
float xv,yv;

x,y,i = 0;
 
pc.baud(9600);

pc.printf("\e[H\e[2J");
//pc.printf("\33[H\33[2J");
//printf(“\e[1;1H\e[2J”);

pc.printf("\t Hello World!!! - Здравствуйте Мир!!! - 大家好！！！\n\r");
pc.printf("\n\rWelcome to the world of ADC (A0 and A1) conected to the MH Joystick \n\r- Digital In (PC_13) to Joystick SWitch included\n\r");
pc.printf("\n\r\t\t\t\t!!!ATTENTION!!! \n\r=> Joystick +5V pin MUST be connected to NUCLEO-F103RB 3V3 pin to avoid damaging NUCLEOs ADC!!!\n\r");
pc.printf("\n\r%s\t\t\t\t%s\t\t\t\t%s\n\r","Eixo X", "Eixo Y", "Tecla SW");

  while(1) {

//    pc.printf("Eixo X = %f \n", VRX.read_u16());
//    pc.printf("VRX = %f \t", VRX.read());
//    pc.printf("VRY = %f \t", VRY.read());

    xv = VRX.read()*3.300;          //lê valor da entrada analógica de 0,0 a 1,0 = full ADC conversion range 
    yv = VRY.read()*3.300;          //e converte para faixa de 0,0 a 3,3V da alimentação
    
    x = VRX.read()*255;             //Converte uma leitura do ADC em float para formato int e armazena na variável x
    y = VRY.read()*255;             //Converte uma leitura do ADC em float para formato int e armazena na variável y
    
    pc.printf("VRX = %1.3fV (%03dd - 0x%02Xh)\t", xv, x, x);
    pc.printf("VRY = %1.3fV (%03dd - 0x%02Xh)\t", yv, y, y);
    
    if (SW == 0) {                  // Botão usuário pressionado
      myled = 1;
      wait(0.1);
      myled = 0;
      i++;       }
      
    pc.printf("SW = %d\r",i);
 
    wait(0.1);

 }
}
            
