#include "mbed.h"
#include "reScale.h"

Ticker flipper;

DigitalOut  controlLED(D13); 
DigitalOut  Splug_1(D2);
DigitalOut  Splug_2(D3);
DigitalOut  Splug_3(D4);
DigitalOut  Splug_4(D5);

//Timer t1;
Timer t2;

Serial device(USBTX, USBRX); // tx, rx

bool flag;
float time_rpm = 0;
int dwell = 2500;




void flip() 
{
    flag=!flag;
    controlLED=!controlLED;
}

void flushSerialBuffer(void) //rotina para limpar o buffer da serial
{ 
    char char1 = 0;
    while (device.readable()) 
    { 
        char1 = device.getc();
    } return; 
}

void set_parameters()
{
    int uni, dez, cen, mil;
    char c[5];
    int i = 0;
    
    c[i] = device.getc();
    i++;
       
    if(c[0] == 'T' || 'R')
    {
        while(i<5)
        {
            c[i] = device.getc();
            i++;
        }
        
        device.printf("%c %c %c %c %c \n\r",c[0], c[1], c[2], c[3], c[4]);
    }
    
    else
    {
        device.printf("Invalid\n\r");
        flushSerialBuffer();
    }
        
    if(c[0] == 'T') 
    {      
    
        mil = atoi(&c[1]);
        //mil = mil * 1000;
        dwell = mil;
        device.printf("%i \n\r",mil);
        
        cen = atoi(&c[2]);
        //cen = cen * 100;
        device.printf("%i \n\r",cen);
        
        dez = atoi(&c[3]);
        //dez = dez * 10;
        device.printf("%i \n\r",dez);
        
        uni  = atoi(&c[4]);
        device.printf("%i \n\r",uni);
                
        //dwell = mil + cen + dez + uni;
        device.printf("Dwell %i uS\n\r",dwell);
        flushSerialBuffer();
    } 
    
    if(c[0] == 'R') 
    {     
        mil = atoi(&c[1]);
        //mil = mil * 1000;
        time_rpm = mil;
        //device.printf("%i \n\r",mil);
        
        cen = atoi(&c[2]);
        //cen = cen * 100;
        //device.printf("%i \n\r",cen);
        
        dez = atoi(&c[3]);
        //dez = dez * 10;
        //device.printf("%i \n\r",dez);
         
        uni  = atoi(&c[4]);
        //device.printf("%i \n\r",uni);
          
        //time_rpm = mil + cen + dez + uni;
               
        time_rpm = 1/time_rpm;       
        
        device.printf("%f S\n\r",time_rpm);
        
        flipper.attach(&flip, time_rpm);
        flushSerialBuffer();
    } 
}    

int main() 
{   
    bool valid_pulse;
    int Splug_counter = 1;
    
    time_rpm = 0.02;
    flipper.attach(&flip, time_rpm);
    
    device.printf("Start\n\r");
    
    while(1)    
    {   
        
    //t1.reset();
    //t1.start();     
            
        if(device.readable())
        {
            set_parameters();   
        }
        
        
        if(Splug_counter > 4)
        {
            Splug_counter = 1;
        }
        
        if(t2.read_us() > dwell)
        {   
            t2.stop();
            Splug_1 = 0;
            Splug_2 = 0;
            Splug_3 = 0;
            Splug_4 = 0;
        }
        if((Splug_counter == 1) && (valid_pulse == 1))
        {
            valid_pulse = 0; 
            Splug_1 = 1;
            Splug_2 = 0;
            Splug_3 = 0;
            Splug_4 = 0;
            t2.reset();
            t2.start();
        }
         
        if((Splug_counter == 2) && (valid_pulse == 1))
        {
            valid_pulse = 0; 
            Splug_1 = 0;
            Splug_2 = 0;
            Splug_3 = 1;
            Splug_4 = 0;
            t2.reset();
            t2.start();
        }
        
        if((Splug_counter == 3) && (valid_pulse == 1))
        {
            valid_pulse = 0; 
            Splug_1 = 0;
            Splug_2 = 0;
            Splug_3 = 0;
            Splug_4 = 1;
            t2.reset();
            t2.start();
        }
        
        if((Splug_counter == 4) && (valid_pulse == 1))
        {
            valid_pulse = 0; 
            Splug_1 = 0;
            Splug_2 = 1;
            Splug_3 = 0;
            Splug_4 = 0;
            t2.reset();
            t2.start();
        }
        
        
        if(flag==1)
        {
            Splug_counter++;
            flag=0;
            valid_pulse = 1;
        }
        
        //t1.stop();
        //printf("O ciclo levou: %i uS \n\r", t1.read_us());
    }
}