// Data: 22/04/2021
// Objetivo: Lendo valor na porta analógica da Nucleo 
// Status: Funcionando
// usando mbed 2.0

#include "Arduino.h"
#include "mbed.h"
#include <MCUFRIEND_kbv.h>
MCUFRIEND_kbv tft;

Serial pc(USBTX, USBRX);
AnalogIn var (A5);

int varleit;

// Assign human-readable names to some common 16-bit color values:
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF
#define GRAY    0x8410

uint16_t version = MCUFRIEND_KBV_H_;

int main ()
{
    pc.baud(9600);
    tft.begin();


    while(1) {
        varleit = var.read()*1000;

        static uint8_t aspect = 0;
        const char *aspectname[] = {
            "PORTRAIT", "LANDSCAPE", "PORTRAIT_REV", "LANDSCAPE_REV"
        };
        const char *colorname[] = { "BLUE", "GREEN", "RED", "GRAY" };
        uint16_t colormask[] = {BLUE};
        int width = tft.width();
        int height = tft.height();
        tft.fillScreen(colormask[aspect]);
        tft.drawRect(0, 0, width, height, WHITE);
        tft.drawRect(32, 32, width - 64, height - 64, WHITE);
        tft.setTextSize(2);
        tft.setTextColor(BLACK);
        tft.setCursor(40, 40);
        tft.print("INSPER LSM");
         tft.setTextColor(RED);
        tft.setCursor(40, 80);
        tft.print("Valor = ");
        tft.setTextColor(RED);
        tft.setCursor(150, 80);
        tft.print(varleit);
        pc.printf ("valor %d\n\r",varleit);
        wait_ms(600);
    }
}

uint32_t millis(void)
{
    static Timer t;
    static int first = 1;
    if (first) first = 0, t.start();
    return t.read_ms();
}

uint32_t micros(void)
{
    static Timer t;
    static int first = 1;
    if (first) first = 0, t.start();
    return t.read_us();
}

