/*
    *Autor: Hugo Campos
    *Objetivo: Esse código tem como objetivo deixar como exemplo a maneira de como usar os vetores no mBed. 
               1º Botão (bt) = Vai modificando qual led será ligado.
               2º Botão (MEMO) = Memoriza qual led foi selecionado e amarzena no vetor "memory'.
               3º Botão (SELECT) = Ao ser apertado acende os leds de acordo que foram memorizados.
    *Data: 28/05/2021
    *Status: Funcionando
    *Observações: Caso não funcione corretamente coloque um capacitor de 4.7uF em paralelo com o botão (bt) e aumente os delays.
*/
#include "mbed.h"
InterruptIn bt (D11);
DigitalIn  MEMO (USER_BUTTON);
DigitalIn  SELECT (D10);

BusOut LEDS(D2,D3,D4,D5,D6,D7,D8);

int State[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40}; 
int memory[64]; 

Serial pc(USBTX,USBRX);

int ctrl  = 0;
int q0out = 0;
int q1out = 0;
int q2out = 0;

char state = 'a';

int guarda;
int MEM;

int mem_bot;
int SELECT_bot;

void machine (void);

int main()
{
    pc.baud(9600);
    ctrl = bt.read();
    bt.rise(&machine);
    while(1) {
        mem_bot = MEMO.read();
        SELECT_bot = SELECT.read();
//        pc.printf ("Numero selecionada %i\n\r",guarda);
//        pc.printf ("MEM 0= %i MEM 1= %i MEM 2= %i MEM 3= %i\n\r",memory[0],memory[1],memory[2],memory[3]);
        if (( q0out == 0) && (q1out == 0) && (q2out == 0)) {
            guarda = 0;
            wait_ms(200);
        }
        if (( q0out == 0) && (q1out == 0) && (q2out == 1)) {
            guarda = 1;
            wait_ms(200);
        }
        if (( q0out == 0) && (q1out == 1) && (q2out == 0)) {
            guarda = 2;
            wait_ms(200);
        }
        if (( q0out == 0) && (q1out == 1) && (q2out == 1)) {
            guarda = 3;
            wait_ms(200);
        }
        if (( q0out == 1) && (q1out == 0) && (q2out == 0)) {
            guarda = 4;
            wait_ms(200);
        }
        if (( q0out == 1) && (q1out == 0) && (q2out == 1)) {
            guarda = 5;
            wait_ms(200);
        }
        if (( q0out == 1) && (q1out == 1) && (q2out == 0)) {
            guarda = 6;
            wait_ms(200);
        }
        LEDS = State[guarda];
        if (mem_bot == 0)
        {
          memory[MEM] = State[guarda];
          MEM++;
          LEDS = 0;
          wait_ms (200);
        }
        if (SELECT_bot == 0)
        { 
            for (int i = 0; i <=MEM; i++)
            { 
                LEDS = memory[i];   
                wait_ms(1000);
            }          
        }
    }
}
void machine ()
{
    switch(state) {
        case 'a':
            q0out = 0;
            q1out = 0;
            q2out = 0;
            if (ctrl) {
                state = 'b';
            }
            break;
        case 'b':
            q0out = 0;
            q1out = 0;
            q2out = 1;
            if (ctrl) {
                state = 'c';
            }
            break;
        case 'c':
            q0out = 0;
            q1out = 1;
            q2out = 0;
            if (ctrl) {
                state = 'd';
            }
            break;
        case 'd':
            q0out = 0;
            q1out = 1;
            q2out = 1;
            if (ctrl) {
                state = 'e';
            }
            break;
        case 'e':
            q0out = 1;
            q1out = 0;
            q2out = 0;
            if (ctrl) {
                state = 'f';
            }
            break;
        case 'f':
            q0out = 1;
            q1out = 0;
            q2out = 1;
            if (ctrl) {
                state = 'g';
            }
            break;
        case 'g':
            q0out = 1;
            q1out = 1;
            q2out = 0;
            if (ctrl) {
                state = 'a';
            }
            break;
    }
}


