//--------------------------------------------------------------------------
// 2021-06
// Esse programa gera uma senoide com um conversor R2R e uma tabela de senos
// a tabela foi construida no Excel para 90 passos de 1 grau, assim o valor 
// dos senos de 0 a 90 graus sera rebatido para 90 a 180, bem como 180 a 270
// e 270 a 360 graus
// -------------------------------------------------------------------------

#include "mbed.h"

float sinus[]{
0,
0.017452406,
0.034899497,
0.052335956,
0.069756474,
0.087155743,
0.104528463,
0.121869343,
0.139173101,
0.156434465,
0.173648178,
0.190808995,
0.207911691,
0.224951054,
0.241921896,
0.258819045,
0.275637356,
0.292371705,
0.309016994,
0.325568154,
0.342020143,
0.35836795,
0.374606593,
0.390731128,
0.406736643,
0.422618262,
0.438371147,
0.4539905,
0.469471563,
0.48480962,
0.5,
0.515038075,
0.529919264,
0.544639035,
0.559192903,
0.573576436,
0.587785252,
0.601815023,
0.615661475,
0.629320391,
0.64278761,
0.656059029,
0.669130606,
0.68199836,
0.69465837,
0.707106781,
0.7193398,
0.731353702,
0.743144825,
0.75470958,
0.766044443,
0.777145961,
0.788010754,
0.79863551,
0.809016994,
0.819152044,
0.829037573,
0.838670568,
0.848048096,
0.857167301,
0.866025404,
0.874619707,
0.882947593,
0.891006524,
0.898794046,
0.906307787,
0.913545458,
0.920504853,
0.927183855,
0.933580426,
0.939692621,
0.945518576,
0.951056516,
0.956304756,
0.961261696,
0.965925826,
0.970295726,
0.974370065,
0.978147601,
0.981627183,
0.984807753,
0.987688341,
0.990268069,
0.992546152,
0.994521895,
0.996194698,
0.99756405,
0.998629535,
0.999390827,
0.999847695,
1,
};

float VCC,t,T,tos;
int f,freq; //, T;
BusOut saida(D4, D5, D6, D7, D8, D9, D10, D11);

int main()
{
    VCC = 3.3;                                        //used for determing offset voltage
    freq = 60;                                        //freq. in Hz
    tos = 15.5;                                        //time off-set in us (5.6ms / 350 = 15.5us)
    t = 30;
    T = t - tos; //T = 30; //(1/freq)/360;                                  //time slice in seconds for the sinusoid routine

    while (true)
    {
        for (int i=0; i < 90; i++)                     //0 to 90 degree
        {
            f=74*((sinus[i]*VCC/2)+VCC/2)+10;          //59 and 60 are adj for 1/4 of the FFh range(8bit) according to Vref
            saida = f;
//            printf("%1.3f", j);
            wait_us(T);//wait(T);
        }
        
        for (int i=90; i > 0; i--)                     //90 to 180 degree
        {
            f=74*((sinus[i]*VCC/2)+VCC/2)+10;
            saida = f;
//            printf("%1.3f", j);
            wait_us(T);//wait(T);
        }
            
        for (int i=0; i < 90; i++)  //180 to 270 degree
        {
            f=74*((-sinus[i]*VCC/2)+VCC/2)+10;
            saida = f;
//            printf("%1.3f", j);
            wait_us(T);//wait(T);
        }
            
        for (int i=90; i > 0; i--)  //270 to 360 degree
        {
            f=74*((-sinus[i]*VCC/2)+VCC/2)+10;
            saida = f;
//            printf("%1.3f", j);
            wait_us(T);//wait(T);
        }
        
    }
}