#include "mbed.h"
#include "L6230_BLDC.h"
#include "reScale.h"

L6230_BLDC motor(PC_10, PC_11, PC_12, PA_8, PA_9, PA_10);

AnalogIn feedback_phase_A(PA_0);
AnalogIn feedback_phase_B(PC_1);
AnalogIn feedback_phase_C(PC_0);

AnalogIn pot(PB_1);

DigitalOut myled(LED1);

DigitalIn sw(PC_13);

Serial pc(USBTX, USBRX);

reScale _scale(0, 4095, 800, 5000); 

float read_current(char);

int prevStep;

long speed;
long adc;

bool start = 0;

int main() 
{
    pc.baud(115200);   
            
    pc.printf("Started\r");
    
    while(1) 
    {
            if((sw == 0) && (start == 0))
            {
                start = 1;
                wait(1);
            }
            
            if((sw == 0) && (start == 1))
            {
                start = 0;
                wait(1);
            }
            
            if(start == 1)
            {
                adc = pot.read() * 4096;
                speed =_scale.from(adc);
                //pc.printf("%i\r",speed);  
                motor.one_step(1, speed, &prevStep);
            }
            else
            {
                motor.stop();
            }
    }
}

float read_current(char PHASE)
{
    float ADC_VALUE;
    
    switch (PHASE)
    {
        case 1: ADC_VALUE = feedback_phase_A.read() * 3.3f; break;  //convert to volts
        case 2: ADC_VALUE = feedback_phase_B.read() * 3.3f; break;  //convert to volts
        case 3: ADC_VALUE = feedback_phase_C.read() * 3.3f; break;  //convert to volts
    }
    
    float CURRENT = ADC_VALUE / 0.33f; // U = R*I, I = U/R (R = 330mOhm)
    
    return CURRENT;
}