#include "mbed.h"
#include "ShiftReg.h"

Ticker flipper;

Timer T1;

ShiftReg HC595(D8, D4, D7);

AnalogIn analog_value(A0);

DigitalOut CLK(D7);
DigitalOut LAT(D4);
DigitalOut DATA(D8);

DigitalIn SW1(A1);
DigitalIn SW2(A2);
DigitalIn SW3(A3);


PwmOut BEEP(D3);

Serial pc(USBTX, USBRX); // tx, rx

int second = 0;
int minute = 0;
int hour = 0;

const int SEGMENT_MAP_DIGIT[] = {0xC0,0xF9,0xA4,0xB0,0x99,0x92,0x82,0xF8,0X80,0X90};
const int SEGMENT_SELECT[] = {0xF1,0xF2,0xF4,0xF8};

void WriteToDisplay(int Segment, int Point, int Number);
void time_base();
void MoreMinute();


int main()
{
    pc.printf("\n\r74HC595 example\n\r");
    
    // clear shift and store registers initially
    HC595.ShiftByte(0x00, ShiftReg::MSBFirst); HC595.Latch(); wait(1);     
    
    BEEP.period(0.00204f);
    
    flipper.attach(&time_base, 1.0f); 

    while(1) 
    {
        if(second >= 60)
        {
            second = 0;
            minute++;
            BEEP = 0.5f;
            wait(0.5);
            BEEP = 0.0f;
        }
        
        if(minute >= 60)
        {
            minute = 0;
            hour++; 
        }
        
        if(hour >= 24)
        {
            hour = 0; 
        }
        
        if(SW1 == 0)
        {
            flipper.detach();
            MoreMinute();
        }
        
        //printf("\n\r %i:%i:%i", hour, minute, second);
        
        WriteToDisplay(1, 0, (minute / 10));
        WriteToDisplay(2, 1, (minute % 10));
        WriteToDisplay(3, 0, (second / 10));
        WriteToDisplay(4, 0, (second % 10));
    }
}






void WriteToDisplay(int Segment, int Point, int Number)
{
    if(Point == 1)
    {
        HC595.ShiftByte(SEGMENT_MAP_DIGIT[Number] & 0x7F, ShiftReg::MSBFirst);    
        HC595.ShiftByte(SEGMENT_SELECT[Segment - 1], ShiftReg::MSBFirst); 
        HC595.Latch();
    } 
        
    else
    {
        HC595.ShiftByte(SEGMENT_MAP_DIGIT[Number], ShiftReg::MSBFirst);    
        HC595.ShiftByte(SEGMENT_SELECT[Segment - 1], ShiftReg::MSBFirst); 
        HC595.Latch();
    } 
}

void time_base()
{
    second++;
} 

void MoreMinute()
{
    bool exit = 0;
    
    while(exit == 0)
    {
        if(SW1 == 0)
        {
            wait_ms(100);
            if(SW1 == 0)
            {
                minute++;
                WriteToDisplay(1, 0, (minute / 10));
                WriteToDisplay(2, 1, (minute % 10));
                WriteToDisplay(3, 0, (second / 10));
                WriteToDisplay(4, 0, (second % 10));
            }
        }
        
        if(SW3 == 0)
        {
            wait_ms(100);
            if(SW3 == 0)
            {
                exit = 1;
                for(int i = 0; i < 3; i++)
                {
                    BEEP = 0.5f;
                    wait(0.15);
                    BEEP = 0.0f;
                    wait(015);
                }   
            }
        }    
    }
    flipper.attach(&time_base, 1.0f); 
    exit = 0;
}