#include "mbed.h"
#include "Servo.h"
#include "Motor.h"

void mov1(void); // Defining functions
void mov2(void);
void mov3(void);

Servo uparm(p21); // Assigns pins to servo
Servo lowarm(p22);
Motor table(p26, p29, p30); // Assigns DC pins

DigitalIn base(p20); // Assigns switch pins 
DigitalIn s2(p19);
DigitalIn s3(p18);
DigitalIn s4(p17);
DigitalOut lights[5] = {p5,p6,p7,p8,p11}; // Assigns LED pens

int a,b,c,d;

int main() 
{

    uparm.calibrate(0.0009,90);// calibrates arm loaations
    lowarm.calibrate(0.0009,90);
    uparm = .5; // halfway points 
    lowarm = .5;


while(1){ // continuous while statement 
    
    a = base.read(); // reads in switch values 
    b = s2.read(); 
    c = s3.read();
    d = s4.read();
    
    if (a==0) { // if switch one is off, entire program does not turn on and arms calibrate 
        table.speed(0);
        uparm = .5;
        lowarm = .5;
        lights[0]=1;
        lights[1]=0;
        lights[2]=0;
        lights[3]=0;
        lights[4]=0;
    } // end if
    
    else if (a==1 && b==0 && c==0 && d==0)
    { // if only switch one is on, lights are on and table spins. 
        table.speed(.4);
        lights[0]=1;
        lights[1]=1;
        lights[2]=0;
        lights[3]=0;
        lights[4]=0;
        printf("Turning");
    } // end if 
   
    else if (a==1 && b==1 && c==0 && d==0){ // if switches one and two are on, table spins, and movement 1 happens
        table.speed(.4);
        lights[0]=1;
        lights[1]=1;
        lights[2]=1;
        lights[3]=0;
        lights[4]=0;
        mov1();
        
    } // end if
    else if (a==1 && b==0 && c==1 && d==0){ // if switches one and three on, table spins, movement two happens
        table.speed(.4);
        lights[0]=1;
        lights[1]=1;
        lights[2]=1;
        lights[3]=1;
        lights[4]=0;
        mov2();
        
    } // end if 
    else if (a==1 && b==0 && c==0 && d==1){ // if switches one and three are on, table speens, movement three
        table.speed(.4);
        lights[0]=1;
        lights[1]=1;
        lights[2]=1;
        lights[3]=1;
        lights[4]=1;
        mov3();
       
    } // end if 
    else{
        table.speed(0);
        uparm = .5;
        lowarm = .5;
        lights[0]=1;
        lights[1]=0;
        lights[2]=0;
        lights[3]=0;
        lights[4]=0;
    } // end if
        wait(.02);
}// end while
} // end main



 void mov1(void){
    int i;
    int j;
    lowarm = .5;
    uparm = .5;
    while(a==1 && b==1 && c==0 && d==0){
    a = base.read(); // reads in switch values 
    b = s2.read(); 
    c = s3.read();
    d = s4.read();
    for (i=0; i<40; i++){
    uparm = .5 + i*0.0041666;
    wait(.038);
    }
    uparm = 0.66667;
    for (j=0; j<40; j++){
    uparm = 0.66667-j*0.0041666;
    wait(.038);
    printf("Movement 1 \n\r");
    }
    }
}
    

void mov2(void){
    int i;
    int j;
    lowarm = .5;
    uparm = .5;
    while(a==1 && b==0 && c==1 && d==0){
    a = base.read(); // reads in switch values 
    b = s2.read(); 
    c = s3.read();
    d = s4.read();
    for (i=0; i<40; i++){
    uparm = .5 + i*0.00208333;
    lowarm = .5 + i*0.0041666;
    wait(.038);
    }
    uparm = 0.58333;
    lowarm= 0.66667;
    for (j=0; j<40; j++){
    uparm = 0.58333-j*0.00208333;
    lowarm = 0.66667-j*0.0041666;
    wait(.038);
    printf("Movement 2 \n\r");
    }
    }
}

void mov3(void) {
    int i;
    int j;
    lowarm = .5;
    uparm = 0.66667;
    while(a==1 && b==0 && c==0 && d==1){
    a = base.read(); // reads in switch values 
    b = s2.read(); 
    c = s3.read();
    d = s4.read();
    for (i=0; i<40; i++){
    uparm = 0.66667 - i*0.0041666;
    lowarm = .5 + i*0.0041666;
    wait(.038);
    }
    uparm = 0.5;
    lowarm= 0.66667;
    for (j=0; j<40; j++){
    uparm = .5 + j*0.0041666;
    lowarm = 0.66667-j*0.0041666;
    wait(.038);
    printf("Movement 3 \n\r");
    }
    }
}
