#include "mbed.h"
#include <string.h>

//------------------------------------------------------------------------------------
/* This example was tested on C027-U20 and C027-G35 with the on board modem.

   Additionally it was tested with a shield where the SARA-G350/U260/U270 RX/TX/PWRON
   is connected to D0/D1/D4 and the GPS SCL/SDA is connected D15/D15. In this
   configuration the following platforms were tested (it is likely that others
   will work as well)
   - U-BLOX:    C027-G35, C027-U20, C027-C20 (for shield set define C027_FORCE_SHIELD)
   - NXP:       LPC1549v2, LPC4088qsb
   - Freescale: FRDM-KL05Z, FRDM-KL25Z, FRDM-KL46Z, FRDM-K64F
   - STM:       NUCLEO-F401RE, NUCLEO-F030R8
                mount resistors SB13/14 1k, SB62/63 0R
*/
#include "GPS.h"
#include "MDM.h"
//------------------------------------------------------------------------------------
// You need to configure these cellular modem / SIM parameters.
// These parameters are ignored for LISA-C200 variants and can be left NULL.
//------------------------------------------------------------------------------------
//! Set your secret SIM pin here (e.g. "1234"). Check your SIM manual.
#define SIMPIN      "1234"
/*! The APN of your network operator SIM, sometimes it is "internet" check your
    contract with the network operator. You can also try to look-up your settings in
    google: https://www.google.de/search?q=APN+list */
#define APN         NULL
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    NULL
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    NULL
//------------------------------------------------------------------------------------

#define RVA 0
#define RPA 1
#define RPHVA 2
#define RPHPHVA 3
#define essaimage 4
#define tarage 5 

AnalogIn analog_value(PC_5);

static float variation_poids=0;
static float poids_ruche=0;
static float poids_prece=0;

//const char num1[]="0652330722"; //jamoud
//const char num1[]="0685350930"; //paul bonnet
//const char num1[]="0685209401"; //benji 
const char num1[]="0609168455"; //garsonnat
static char chaine[255];
static int flag = 0;


static int cpt=0;
static float tabPoids[2000];
static float poidsMoyenne=0;
static float offset=0;

Serial pc(USBTX, USBRX);
// Create the modem object
MDMSerial mdm;

void sendMessage()
{
     // initialize the modem
            MDMParser::DevStatus devStatus = {};
            MDMParser::NetStatus netStatus = {};

            bool mdmOk = mdm.init(SIMPIN, &devStatus, D4);
            while(mdmOk == false)mdmOk = mdm.init(SIMPIN, &devStatus, D4);

            bool launchOK = mdm.checkNetStatus(&netStatus);
            while(launchOK == false)launchOK = mdm.checkNetStatus(&netStatus);

            mdm.dumpDevStatus(&devStatus);
            if (mdmOk) {
                mdmOk = mdm.registerNet(&netStatus);
                mdm.dumpNetStatus(&netStatus);
                mdm.smsSend(num1 ,chaine);
            }
            mdm.powerOff();
            flag = 0;
}

float moyennagePoids(float poids[]){
    
    float poidsFinal;
    int i=0;
    for(i=0;i<2001;i++)
    {
        poidsFinal+=poids[i];    
    }
    poidsFinal/=2001;
    return poidsFinal;  
}

void acquisition(){
        
        poids_ruche=analog_value.read();
        offset = poids_ruche;
        poids_ruche = poids_ruche * 3300;
        //pc.printf("Poids 1 = %2.2f mV\r\n",poids_ruche);

        poids_ruche=((0.030151089*poids_ruche)-6.3);   //0.030151089 * x - 5.7390218965 
        pc.printf("Poids 2 = %2.2f Kg\r\n",poids_ruche);

        wait(0.5);
        
        if(cpt<2001) {
            tabPoids[cpt]=poids_ruche;
        } else if(cpt==2001) {
            poidsMoyenne=moyennagePoids(tabPoids);
            pc.printf("Poids Moyen = %2.2f Kg\r\n",poidsMoyenne);
            wait(1.5);
            cpt=0;
        }
        cpt++;
}

void automate()
{
    static int etat_ruche_courant = RVA;
    static int etat_ruche_futur, etat_precedent;

    etat_ruche_courant = etat_ruche_futur;
    variation_poids = poids_ruche - poids_prece;
    poids_prece = poids_ruche;

    switch(etat_ruche_courant) {

        case RVA:
            if(poids_ruche < 40) {
                if(variation_poids < -2)
                {   etat_precedent = RVA;
                    etat_ruche_futur = essaimage;
                }
                if(variation_poids > 0) {
                    etat_ruche_futur = RVA;
                }
                if(variation_poids == 0) {
                    etat_ruche_futur = RVA;
                }
            }
            if(poids_ruche >= 40) {

                sprintf(chaine, "recolte hausse n1\r\n poids = %2.f", poids_ruche);
                flag = 1;
                etat_ruche_futur = RPHVA;
            }

            break;

        case RPHVA:
            if(poids_ruche < 56) {
                if(variation_poids < -2)
                {   etat_precedent = RPHVA;
                    etat_ruche_futur = essaimage;
                }
                if(variation_poids > 0) {
                    etat_ruche_futur = RPHVA;
                }
                if(variation_poids == 0) {
                    etat_ruche_futur = RPHVA;
                }
            }
            if(poids_ruche >= 56) {
                sprintf(chaine, "recolte hausse n2\r\n poids = %2.f", poids_ruche);
                flag = 1;
                etat_ruche_futur = RPHPHVA;
            }

            break;

        case RPHPHVA:
            if(poids_ruche < 72) {
                if(variation_poids < -2)
                {   etat_precedent = RPHPHVA;
                    etat_ruche_futur = essaimage;
                }
                if(variation_poids > 0) {
                    etat_ruche_futur = RPHPHVA;
                }
                if(variation_poids == 0) {
                    etat_ruche_futur = RPHPHVA;
                }
            }
            if(poids_ruche > 72) {
                sprintf(chaine, "recolte hausse n1 & n2\r\n poids = %2.f", poids_ruche);
                flag = 1;
                etat_ruche_futur = RVA;
            }
            break;
            case essaimage:
                sprintf(chaine, "BELEK essaimage !!! \r\n");
                flag = 1;
                etat_ruche_futur = etat_precedent;
            break;
    }
}

int main(void)
{
    pc.baud(115200);
    
    while(1) {
        
        acquisition();
        automate();
        
        if(flag == 1) {          
            sendMessage();
        }
    }
}





