#ifndef __main__
#define __main__
#include "variables.hpp"
#include "math.hpp"
#include "dataStore.h"
#include "DebounceIn.h"


dataStore loopBuffer[MAX_SAMPLES];
InterruptIn clockin(PB_0);
DigitalIn runsw(PC_0);
InterruptIn loopsw(PC_1);
AnalogIn analog_valuea(PA_0);
AnalogIn analog_valueb(PA_4);
AnalogIn analog_valuec(PB_2);
DigitalOut led(PC_2);
BusOut multiplexa(PC_4,PC_5,PC_6);
BusOut multiplexb(PC_7,PC_8,PC_9);
BusOut multiplexc(PC_10,PC_11,PC_12);
DigitalOut ledclock(PB_10);
DigitalOut ledlatch(PB_12);
DigitalOut leddata(PB_11);
DigitalOut lrun(PC_2);
DigitalOut lloop(PC_3);
DigitalOut trigout(PA_5);
SPI dac(PB_5,PB_4,PB_3);
Serial pc(PB_6, PA_10);
DigitalOut cs(PB_9);
DigitalOut clockout(PA_12);
//tempo val mapped
float tempoval;
int clockcount;
int targetnumber;
//ADC SETUP
float adc1; 
float adc2;
float adc3; 
// LED CONTROL 
bool lc;
bool lcshp;
bool ld;
bool ldshp;
bool le;
bool lf;
bool lfshp;
bool lg;
bool lgshp;
bool la;
bool lashp;
bool lb;
bool lsixteenth;
bool leighth;
bool lquater;
bool lhalf;
bool lone;
bool ltwo;
bool lnegtwo;
bool lnegone;
bool lzero;
bool lplusone;
bool lplustwo;

void pointerHandler(void){
        //Set seperate FIFO head and tail for printing data
        dataHeader = bufferHeader;
        dataTail = bufferTail;

        //Move sample FIFO buffer head to next row in buffer
        bufferHeader++;
        //Check sample FIFO buffer head
        if(bufferHeader >= MAX_SAMPLES) {
            bufferHeader = 0;
        }
        //Check sample FIFO buffer tail
        if(bufferTail == bufferHeader) {
            bufferTail++;
            if(bufferTail >= (MAX_SAMPLES)) {
                bufferTail = 0;
            }
        }
    }

void updateled(void){
    ledlatch = 1;
    ledlatch = 0;
    leddata = lsixteenth; //LABEL 1/16
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = leighth; //LABEL 1/8
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = lquater; //LABEL 1/4
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = lhalf; //LABEL 1/2
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = lone; //LABEL 1
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = ltwo; //LABEL 2
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = lnegtwo; //LABEL -2
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = lnegone; //LABEL -1
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = lzero; //LABEL = 0
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = lplusone; //LABEL 1
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = lplustwo; //LABEL 2 
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = 0; //LABEL no
    ledclock = 1;
    ledclock = 0;
    leddata = 0;
    leddata = 1; //LABEL no 
    ledclock = 1;
    ledclock = 0;
    leddata = 0;    
    leddata = 1; //LABEL no
    ledclock = 1;
    ledclock = 0;
    leddata = 0;     
    leddata = 0; //LABEL no
    ledclock = 1;
    ledclock = 0;
    leddata = 0;  
    leddata = lb; //LABEL B
    ledclock = 1;
    ledclock = 0;
    leddata = 0;   
    leddata = lashp; //LABEL A#
    ledclock = 1;
    ledclock = 0;
    leddata = 0;       
    leddata = la; //LABEL A
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = lgshp; //LABEL G# 
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = lg; //LABEL G
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = lfshp; //LABEL F#
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = lf; //LABEL F
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = le; //LABEL E
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = ldshp; //LABEL D#
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = ld; //LABEL D
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = lcshp; //LABEL C#
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    leddata = lc; //LABEL C
    ledclock = 1;
    ledclock = 0;
    leddata = 0; 
    
    }
void allledon(void){
lc=1;
lcshp=1;
ld=1;
ldshp=1;
le=1;
lf=1;
lfshp=1;
lg=1;
lgshp=1;
la=1;
lashp=1;
lb=1;
lsixteenth=1;
leighth=1;
lquater=1;
lhalf=1;
lone=1;
ltwo=1;
lnegtwo=1;
lnegone=1;
lzero=1;
lplusone=1;
lplustwo=1;
lrun = 0;
lloop = 0;
}
void allledoff(void){
lc=0;
lcshp=0;
ld=0;
ldshp=0;
le=0;
lf=0;
lfshp=0;
lg=0;
lgshp=0;
la=0;
lashp=0;
lb=0;
lsixteenth=0;
leighth=0;
lquater=0;
lhalf=0;
lone=0;
ltwo=0;
lnegtwo=0;
lnegone=0;
lzero=0;
lplusone=0;
lplustwo=0;
lrun = 1;
lloop = 1;
}
void post(void){
    allledon();
    wait(0.5);
    allledoff();
    wait(0.5);
    allledon();
    wait(0.5);
    allledoff();
    wait(0.5);
    allledon();
    wait(0.5);
    allledoff();
    wait(0.5);
    
    }
 void getfaderdata(void){
    multiplexa = 0;
    adc1 = analog_valuea.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc1 = adc1 *100;
    vc = adc1;
    multiplexa = 1;
    adc1 = analog_valuea.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc1 = adc1 *100;
    vcshp = adc1;
    multiplexa = 2;
    adc1 = analog_valuea.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc1 = adc1 *100;
    vd = adc1;
    multiplexa = 3;
    adc1 = analog_valuea.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc1 = adc1 *100;
    vdshp = adc1;
    multiplexa = 4;
    adc1 = analog_valuea.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc1 = adc1 *100;
    ve = adc1;
    multiplexa = 5;
    adc1 = analog_valuea.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc1 = adc1 *100;
    vf = adc1;
    multiplexa = 6;
    adc1 = analog_valuea.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc1 = adc1 *100;
    vfshp = adc1;
    multiplexa = 7;
    adc1 = analog_valuea.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc1 = adc1 *100;
    vg = adc1; 
    multiplexb = 0;
    adc2 = analog_valueb.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc2 = adc2 *100;
    vgshp = adc2;
    multiplexb = 1;
    adc2 = analog_valueb.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc2 = adc2 *100;
    va = adc2;
    multiplexb = 2;
    adc2 = analog_valueb.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc2 = adc2 *100;
    vashp = adc2;
    multiplexb = 3;
    adc2 = analog_valueb.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc2 = adc2 *100;
    vb = adc2;
    multiplexb = 4;
    adc2 = analog_valueb.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc2 = (adc2 *255);
    vtempo = adc2;
    multiplexb = 5;
    adc2 = analog_valueb.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc2 = adc2 *100;
    vplustwo = adc2;
    multiplexb = 6;
    adc2 = analog_valueb.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc2 = adc2 *100;
    vplusone = adc2;
    multiplexb = 7;
    adc2 = analog_valueb.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc2 = adc2 *100;
    vzero = adc2;
    multiplexc = 0;
    adc3 = analog_valuec.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc3 = adc3 *100;
    vnegone = adc3;
    multiplexc = 1;
    adc3 = analog_valuec.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc3 = adc3 *100;
    vnegtwo = adc3;
    multiplexc = 2;
    adc3 = analog_valuec.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc3 = adc3 *100;
    vtwo = adc3;
    multiplexc = 3;
    adc3 = analog_valuec.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc3 = adc3 *100;
    vone = adc3;
    multiplexc = 4;
    adc3 = analog_valuec.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc3 = adc3 *100;
    vhalf = adc3;
    multiplexc = 5;
    adc3 = analog_valuec.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc3 = adc3 *100;
    vquater = adc3;
    multiplexc = 6;
    adc3 = analog_valuec.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc3 = adc3 *100;
    veigth = adc3;
    multiplexc = 7;
    adc3 = analog_valuec.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    adc3 = adc3 *100;
    vsixthteenth = adc3;
}   
void serialfadervalues(void){
    pc.printf("CHA %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f \n\r",vc,vcshp,vd,vdshp,ve,vf,vfshp,vg);
    pc.printf("CHC %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f \n\r",vnegone,vnegtwo,vtwo,vone,vhalf,vquater,veigth,vsixthteenth); 
    pc.printf("CHB %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f %4.2f \n\r",vgshp,va,vashp,vb,vtempo,vplustwo,vplusone,vzero); 
}
// SUM OF THE PROABILITIES!!! 
void sumprobabilitynotes(void){
    sumnotes = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg+vgshp+va+vashp+vb;
    //pc.printf("sum of notes %f \n\r",sumnotes);
    sumnotes2 = sumnotes;
    }
void sumprobabilityoctives(void){
    sumoctives = vplustwo+vplusone+vzero+vnegone+vnegtwo;
    //pc.printf("sum of octives %f \n\r",sumoctives);
    sumoctives2 = sumoctives;
    }
void sumprobabilityduration(void){
    sumduration = vtwo+vone+vhalf+vquater+vsixthteenth+veigth;
    //pc.printf("sum of duration %f \n\r",sumduration);
    sumduration2 = sumduration;
    }
//RANDOM GENERATORS!!!!
void randomgeneratenotes(void){
    randomnotes=rand()%sumnotes2;
    //pc.printf("random notes is %i \n\r",randomnotes);
    }
void randomgenerateoctives(void){
    randomoctives=rand()%sumoctives2;
    //pc.printf("random octives is %i \n\r",randomoctives);
    }
void randomgenerateduration(void){
    randomduration=rand()%sumduration2;
    //pc.printf("random duration is %i \n\r", randomduration);
}
//DERTERNINE THE RANDOM SELECTIONS (REALISE THE PROBABALISED)     
void determinenotes(void){
  matchflagnotes = 0;
  matchnotelower = 0;
  matchnotehigher = vc;
  if(randomnotes > 0 && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched C\n\r");
  matchflagnotes = 1;
  note = 1;
  }
  matchnotelower = vc;
  matchnotehigher = vc+vcshp;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched C#\n\r");
  matchflagnotes = 1;
  note = 2;
  }
  matchnotelower = vc+vcshp;
  matchnotehigher = vc+vcshp+vd;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched D\n\r");
  matchflagnotes = 1;
  note = 3;
  }
  matchnotelower = vc+vcshp+vd;
  matchnotehigher = vc+vcshp+vd+vdshp;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched D#\n\r");
  matchflagnotes = 1;
  note = 4;
  }
  matchnotelower = vc+vcshp+vd+vdshp;
  matchnotehigher = vc+vcshp+vd+vdshp+ve;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched E\n\r");
  matchflagnotes = 1;
  note = 5;
  } 
  matchnotelower = vc+vcshp+vd+vdshp+ve;
  matchnotehigher = vc+vcshp+vd+vdshp+ve+vf;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched F\n\r");
  matchflagnotes = 1;
  note = 6;
  }
  matchnotelower = vc+vcshp+vd+vdshp+ve+vf;
  matchnotehigher = vc+vcshp+vd+vdshp+ve+vf+vfshp;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched F#\n\r");
  matchflagnotes = 1;
  note = 7;
  }
  matchnotelower = vc+vcshp+vd+vdshp+ve+vf+vfshp;
  matchnotehigher = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched G\n\r");
  matchflagnotes = 1;
  note = 8;
  }
  matchnotelower = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg;
  matchnotehigher = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg+vgshp;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched G#\n\r");
  matchflagnotes = 1;
  note = 9;
  }
  matchnotelower = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg+vgshp;
  matchnotehigher = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg+vgshp+va;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched A\n\r");
  matchflagnotes = 1;
  note = 10;
  }
  matchnotelower = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg+vgshp+va;
  matchnotehigher = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg+vgshp+va+vashp;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched A#\n\r");
  matchflagnotes = 1;
  note = 11;
  }
  matchnotelower = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg+vgshp+va+vashp;
  matchnotehigher = vc+vcshp+vd+vdshp+ve+vf+vfshp+vg+vgshp+va+vashp+vb;
  if(randomnotes > matchnotelower && randomnotes < matchnotehigher && matchflagnotes == 0){
  probabalisednote = matchnotehigher;
  //pc.printf("Proababilised note matched B\n\r");
  matchflagnotes = 1;
  note = 12;
  }
  if(matchflagnotes == 1){
  //pc.printf("NOTE COMP EMGINE COMPLETE \n\r");    
  }
  if(sumnotes < 1){
  note = 0;
  }    
}
void determineoctives(void){
  matchflagoctive = 0;
  matchoctivelower = 0;
  matchoctivehigher = vnegtwo;
  if(randomoctives > matchoctivelower && randomoctives < matchoctivehigher && matchflagoctive == 0){
  probabalisedoctive = matchoctivehigher;
  //pc.printf("Proababilised octive matched -2 \n\r");
  matchflagoctive = 1;
  octive = 1;
  }
  matchoctivelower = vnegtwo;
  matchoctivehigher = vnegtwo+vnegone;
  if(randomoctives > matchoctivelower && randomoctives < matchoctivehigher && matchflagoctive == 0){
  probabalisedoctive = matchoctivehigher;
  //pc.printf("Proababilised octive matched -1 \n\r");
  matchflagoctive = 1;
  octive = 2;
  }
  matchoctivelower = vnegtwo+vnegone;
  matchoctivehigher = vnegtwo+vnegone+vzero;
  if(randomoctives > matchoctivelower && randomoctives < matchoctivehigher && matchflagoctive == 0){
  probabalisedoctive = matchoctivehigher;
  //pc.printf("Proababilised octive matched 0 \n\r");
  matchflagoctive = 1;
  octive = 3;
  }
  matchoctivelower = vnegtwo+vnegone+vzero;
  matchoctivehigher = vnegtwo+vnegone+vzero+vplusone;
  if(randomoctives > matchoctivelower && randomoctives < matchoctivehigher && matchflagoctive == 0){
  probabalisedoctive = matchoctivehigher;
  //pc.printf("Proababilised octive matched +1 \n\r");
  matchflagoctive = 1;
  octive = 4;
  }
  matchoctivelower = vnegtwo+vnegone+vzero+vplusone;
  matchoctivehigher = vnegtwo+vnegone+vzero+vplusone+vplustwo;
  if(randomoctives > matchoctivelower && randomoctives < matchoctivehigher && matchflagoctive == 0){
  probabalisedoctive = matchoctivehigher;
  //pc.printf("Proababilised octive matched +2 \n\r");
  matchflagoctive = 1;
  octive = 5;
  } 
  if(matchflagoctive == 1){
  //pc.printf("OCTIVES COMP EMGINE COMPLETE \n\r");    
  }
  if(sumoctives < 50){
  octive = 0;
  }
}
void determineduration(void){
  matchflagduration = 0;
  matchdurationlower = 0;
  matchdurationhigher = vsixthteenth;
  if(randomduration > matchdurationlower && randomduration < matchdurationhigher && matchflagduration == 0){
  probabalisedduration = matchdurationhigher;
  //pc.printf("Proababilised duration matched 1/16 \n\r");
  matchflagduration = 1;
  duration = 1;

  }
  matchdurationlower = vsixthteenth;
  matchdurationhigher = vsixthteenth+veigth;
  if(randomduration > matchdurationlower && randomduration < matchdurationhigher && matchflagduration == 0){
  probabalisedduration = matchdurationhigher;
  //pc.printf("Proababilised duration matched 1/8 \n\r");
  matchflagduration = 1;
  duration = 2;
  }
  matchdurationlower = vsixthteenth+veigth;
  matchdurationhigher = vsixthteenth+veigth+vquater;
  if(randomduration > matchdurationlower && randomduration < matchdurationhigher && matchflagduration == 0){
  probabalisedduration = matchdurationhigher;
  //pc.printf("Proababilised duration matched 1/4 \n\r");
  matchflagduration = 1;
  duration = 4;

  }
  matchdurationlower = vsixthteenth+veigth+vquater;
  matchdurationhigher = vsixthteenth+veigth+vquater+vhalf;
  if(randomduration > matchdurationlower && randomduration < matchdurationhigher && matchflagduration == 0){
  probabalisedduration = matchdurationhigher;
  //pc.printf("Proababilised duration matched 1/2 \n\r");
  matchflagduration = 1;
  duration = 8;
  }
  matchdurationlower = vsixthteenth+veigth+vquater+vhalf;
  matchdurationhigher = vsixthteenth+veigth+vquater+vhalf+vone;
  if(randomduration > matchdurationlower && randomduration < matchdurationhigher && matchflagduration == 0){
  probabalisedduration = matchdurationhigher;
  //pc.printf("Proababilised duration matched +1 \n\r");
  matchflagduration = 1;
  duration = 16;
  } 
  matchdurationlower = vsixthteenth+veigth+vquater+vhalf+vone;
  matchdurationhigher = vsixthteenth+veigth+vquater+vhalf+vone+vtwo;
  if(randomduration > matchdurationlower && randomduration < matchdurationhigher && matchflagduration == 0){
  probabalisedduration = matchdurationhigher;
  //pc.printf("Proababilised duration matched +2 \n\r");
  matchflagduration = 1;
  duration = 32;
  } 
  if(matchflagduration == 1){
  //pc.printf("DURATION COMP EMGINE COMPLETE \n\r");    
  }
  if(sumduration < 1){
  duration = 0;
  }
}
//tempo
float map(float in, float inMin, float inMax, float outMin, float outMax) {
  // check it's within the range
  if (inMin<inMax) { 
    if (in <= inMin) 
      return outMin;
    if (in >= inMax)
      return outMax;
  } else {  // cope with input range being backwards.
    if (in >= inMin) 
      return outMin;
    if (in <= inMax)
      return outMax;
  }
  // calculate how far into the range we are
  float scale = (in-inMin)/(inMax-inMin);
  // calculate the output.
  return outMin + scale*(outMax-outMin);
}
void gettempodata(void){
  tempoval = map(vtempo,0,255,255,30);
}
void debugtempodata(void){
  pc.printf("unmapped %f mapped %f\n\r",vtempo,tempoval);
}
void outputdecision(void){
    if(note == 1){
        lc = 1;
    //int duration = 0; //1=1/16 2=1/8 3=1/4 4=1/2 5=1 6=2 

    }
    else if(note == 2){
        lcshp = 1;
    }
    else if(note == 3){
        ld = 1;
    }
    else if(note == 4){
        ldshp = 1;
    }
    else if(note == 5){
        le = 1;
    }
    else if(note == 6){
        lf = 1;
    }
    else if(note == 7){
        lfshp = 1;
    }
    else if(note == 8){
        lg = 1;
    }
    else if(note == 9){
        lgshp = 1;
    }
    else if(note == 10){
        la = 1;
    }
    else if(note == 11){
        lashp = 1;
    }
    else if(note == 12){
        lb = 1;
    }
    else{
     lc = 0;
     lcshp = 0;
     ld= 0;
     ldshp= 0;
     le= 0;
     lf= 0;
     lfshp= 0;
     lg= 0;
     lgshp= 0;
     la= 0;
     lashp= 0;
     lb= 0;
    }
    if(octive == 1){
        lnegtwo = 1;
    }
    else if(octive == 2){
        lnegone = 1;
    }
    else if(octive == 3){
        lzero = 1;
    }
    else if(octive == 4){
        lplusone = 1;
    }
    else if(octive == 5){
        lplustwo = 1;
    }
    else {
        lnegtwo = 0;
        lnegone = 0;
        lzero = 0;
        lplusone = 0;
        lplustwo = 0;
    }
    if(duration == 1){
        lsixteenth = 1;
    }
    else if(duration == 2){
        leighth = 1;
    }
    else if(duration == 4){
        lquater = 1;
    }
    else if(duration == 8){
        lhalf = 1;
    }
    else if(duration == 16){
        lone = 1;
    }
    else if(duration == 32){
        ltwo = 1;
    }
    else {
     lsixteenth = 0;
     leighth = 0;
     lquater = 0;
     lhalf = 0;
     lone = 0;
     ltwo = 0;
    }  
  
}
void senddacout(void){
    //octive 0 
      updateled();
    if(note == 1 && octive == 1){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x00);
    dac.write(0x00);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 2 && octive == 1){ 
     cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x03);
    dac.write(0x0C);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 3 && octive == 1){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x06);
    dac.write(0x18);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 4 && octive == 1){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x09);
    dac.write(0x24);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 5 && octive == 1){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x0C);
    dac.write(0x2F);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 6 && octive == 1){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x0F);
    dac.write(0x3B);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 7 && octive == 1){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x12);
    dac.write(0x47);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 8 && octive == 1){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x15);
    dac.write(0x53);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 9 && octive == 1){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x18);
    dac.write(0x5F);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 10 && octive == 1){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x1B);
    dac.write(0x6B);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 11 && octive == 1){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x1E);
    dac.write(0x77);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 12 && octive == 1){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x21);
    dac.write(0x83);
    cs = 1;
    pc.printf("N2O4\n\r");
    } 
    //OCTIVE -1 
    else if(note == 1 && octive == 2){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x24);
    dac.write(0x8E);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 2 && octive == 2){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x27);
    dac.write(0x9A);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 3 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x2A);
    dac.write(0xA6);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 4 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x2D);
    dac.write(0xB2);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 5 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x30);
    dac.write(0xBE);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 6 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x33);
    dac.write(0xCA);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 7 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x36);
    dac.write(0xD6);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 8 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x39);
    dac.write(0xE2);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 9 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x3C);
    dac.write(0xED);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 10 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x3F);
    dac.write(0xF9);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 11 && octive == 2){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x43);
    dac.write(0x05);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 12 && octive == 2){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x46);
    dac.write(0x11);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    //octive2
    //OCTIVE 1 
    else if(note == 1 && octive == 3){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x49);
    dac.write(0x1D);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 2 && octive == 3){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x4C);
    dac.write(0x29);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 3 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x4F);
    dac.write(0x35);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 4 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x52);
    dac.write(0x40);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 5 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x55);
    dac.write(0x4C);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 6 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x58);
    dac.write(0x58);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 7 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x5B);
    dac.write(0x64);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 8 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x5E);
    dac.write(0x70);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 9 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x61);
    dac.write(0x7C);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 10 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x64);
    dac.write(0x88);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 11 && octive == 3){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x67);
    dac.write(0x94);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 12 && octive == 3){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x6A);
    dac.write(0x9F);
    cs = 1;
    pc.printf("N2O4\n\r");
    }    
    else if(note == 1 && octive == 4){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x6D);
    dac.write(0xAB);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 2 && octive == 4){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x70);
    dac.write(0xB7);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 3 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x73);
    dac.write(0xC3);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 4 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x76);
    dac.write(0xCF);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 5 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x79);
    dac.write(0xDB);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 6 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x7C);
    dac.write(0xE7);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 7 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x7F);
    dac.write(0xF2);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 8 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x82);
    dac.write(0xFE);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 9 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x86);
    dac.write(0x0A);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 10 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x89);
    dac.write(0x16);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 11 && octive == 4){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x8C);
    dac.write(0x22);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 12 && octive == 4){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x8F);
    dac.write(0x2E);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 1 && octive == 5){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x92);
    dac.write(0x3A);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 2 && octive == 5){ 
     cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x95);
    dac.write(0x46);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 3 && octive == 5){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x98);
    dac.write(0x51);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 4 && octive == 5){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x9B);
    dac.write(0x5D);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 5 && octive == 5){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0x9E);
    dac.write(0x69);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 6 && octive == 5){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xA1);
    dac.write(0x75);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 7 && octive == 5){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xA4);
    dac.write(0x81);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 8 && octive == 5){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xA7);
    dac.write(0x8D);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 9 && octive == 5){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xAA);
    dac.write(0x99);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 10 && octive == 5){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xAD);
    dac.write(0xA5);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 11 && octive == 5){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xB0);
    dac.write(0xB0);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 12 && octive == 5){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xB3);
    dac.write(0xBC);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 1 && octive == 6){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xB6);
    dac.write(0xC8);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 2 && octive == 6){ 
     cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xB9);
    dac.write(0xD4);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 3 && octive == 6){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xBC);
    dac.write(0xE0);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 4 && octive == 6){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xBF);
    dac.write(0xEC);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 5 && octive == 6){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xC2);
    dac.write(0xF8);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 6 && octive == 6){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xC6);
    dac.write(0x03);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 7 && octive == 6){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xC9);
    dac.write(0x0F);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 8 && octive == 6){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xCC);
    dac.write(0x1B);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 9 && octive == 6){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xCF);
    dac.write(0x27);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 10 && octive == 6){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xD2);
    dac.write(0x33);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 11 && octive == 6){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xD5);
    dac.write(0x3F);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 12 && octive == 6){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xD8);
    dac.write(0x4B);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 1 && octive == 7){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xDB);
    dac.write(0x57);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 2 && octive == 7){ 
     cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xDE);
    dac.write(0x62);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 3 && octive == 7){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xE1);
    dac.write(0x6E);
    cs = 1;
    pc.printf("N2O4\n\r");
        }
    else if(note == 4 && octive == 7){ 
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xE4);
    dac.write(0x7A);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 5 && octive == 7){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xE7);
    dac.write(0x86);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 6 && octive == 7){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xF5);
    dac.write(0xEA);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 7 && octive == 7){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xED);
    dac.write(0x9E);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 8 && octive == 7){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xF0);
    dac.write(0xAA);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 9 && octive == 7){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xF3);
    dac.write(0xB6);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 10 && octive == 7){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xA5);
    dac.write(0xF6);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 11 && octive == 7){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xF9);
    dac.write(0xCD);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 12 && octive == 7){  
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xFC);
    dac.write(0xD9);
    cs = 1;
    pc.printf("N2O4\n\r");
    }
    else if(note == 1 && octive == 8){
    cs = 1;
    cs = 0;
    dac.write(0x30);
    dac.write(0xFF);
    dac.write(0xE5);
    cs = 1;
    } 
    //save to loop buffer
    if (loop == 0){
    loopBuffer[bufferHeader].update(note, octive, duration);
    pc.printf("Saved note %i, octave %i, duration %i \n\r",loopBuffer[bufferHeader].note(), loopBuffer[bufferHeader].octave(), loopBuffer[bufferHeader].duration());
    pointerHandler();
    }       
    }
#endif   