#include "mbed.h"
#include "LM75B.h"
#include "SB1602E.h"

//Create an LM75B object at the default address (ADDRESS_0)
LM75B sensor(dp5, dp27);
SB1602E lcd( dp5, dp27);

int main()
{   
    //Try to open the LM75B
    if (sensor.open()) {
        printf("Device detected!\n");

        while (1) {
            lcd.clear();
            //Print the current temperature
            lcd.printf(0,"Tmp:%.1f\n", (float)sensor);

            //Sleep for 0.5 seconds
            wait(0.5);
        }
    } else {
        error("Device not detected!\n");
    }
}
