#include "mbed.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "ifttt.h"
#include "LM75B.h"

LM75B sensor(dp5, dp27);
ESP8266Interface wifi(dp16,dp15,dp4,"SSID","Password",115200); // TX,RX,Reset,SSID,Password,Baud

int main()
{
    char value[64];
    
    wifi.init(); //Reset
    wifi.connect(); //Use DHCP
    
    TCPSocketConnection socket;
    
    // Initialize ifttt object, add up to 3 optional values, trigger event. 
    IFTTT ifttt("EverntName","Secret Key", &socket); // EventName, Secret Key, socket to use
    
    sprintf(value,"%.3f", (float)sensor);

    ifttt.addIngredients(value,"value2","value3");
    ifttt.trigger(IFTTT_POST);
}
