#include "mbed.h"
#include "USBSerial.h"

DigitalOut myled(PB_2);
InterruptIn usbPower(PA_9);
USBSerial pcSerial(0x1f00,0x2012,0x001,false);

void usbConnectISR(){
    myled=1;
}
void usbDisconnectISR(){
    myled=0;
}

int main(){
    //USB Development branch
    usbPower.rise(usbConnectISR);
    usbPower.fall(usbDisconnectISR);
    usbPower.enable_irq();
    
    pcSerial.printf("USB PORT SERIAL");
    while(1){
        if(pcSerial.readable()){
            pcSerial.putc(pcSerial.getc());
        }
    }
}
