#include "mbed.h"

DigitalOut Vcc(PA_0);
AnalogIn aInn(PA_1);
DigitalOut Gnd(PA_4);

int main() 
{ 
    Vcc=1;
    Gnd=0;
    float maxVoltage, minVoltage;
    
    maxVoltage = minVoltage=aInn.read()*3.3f;
    while(1)
    {
        float voltage=aInn.read()*3.3f;
        
        if(voltage<maxVoltage)
        maxVoltage=voltage;
        
        if(voltage>minVoltage)
        minVoltage=voltage;
        
        printf("Curent: %.3f Min: %.3f Max: %.3f Max-Min: %.3f\r\n", voltage, maxVoltage, minVoltage, maxVoltage-minVoltage);
        wait_ms(135);
    }
}