#include "mbed.h"
#include <iostream>

#include "FlashIAP.h"
#pragma pack(push,1)
struct packed_A {
    uint32_t magic;
    uint32_t value;

}
#pragma pack(pop)
;

Ticker toggle_led_ticker;
enum { MAGIC_VALUE = 0xDEADBEEF };
DigitalOut led1(LED1);
int counter;
uint32_t sector_size;
uint32_t page_size;
uint32_t prog_size;
uint32_t address;
FlashIAP flash_device;
DigitalIn button(USER_BUTTON);

bool initializeDevice()
{
    return flash_device.init() == 0;
}

void determineValues()
{
    sector_size = flash_device.get_sector_size(flash_device.get_flash_start() + flash_device.get_flash_size() - 1UL);
    page_size = flash_device.get_page_size();
    address = (flash_device.get_flash_start() + flash_device.get_flash_size()) - (sector_size);
    printf("Sector size: %d \r\n", sector_size);
    printf("Page size: %d \r\n", page_size);
    printf("Address: %d \r\n", address);
}

int main()
{
    //Setting up...
    if(initializeDevice()) {
        //Device has been initialized.
        printf("\r\nDevice initialized\r\n");
        determineValues();

        uint8_t *data_flashed = new uint8_t[8];
        uint8_t buffer[8];
        flash_device.read(buffer, address, 8);
        packed_A const *ptr = (packed_A const *) buffer;
        printf("%d", ptr->magic)
        
        packed_A readMemory;

        flash_device.read(data_flashed, address, 8);

        for(int j = 4; j >= 0 ; j--) {
            readMemory.magic <<= 8;                         //Bit-shifting the input because input is (239 190 173 222) and deadbeef is (222 173 190 239)
            readMemory.magic += data_flashed[j];
        }
        for(int j = 8; j >= 4 ; j--) {
            readMemory.value <<= 8;                         //Bit-shifting the data into a uint
            readMemory.value += data_flashed[j];
        }

        printf("Magic: 0x%x \r\n", readMemory.magic);

        if(readMemory.magic == MAGIC_VALUE) {
            printf("Address initialized, counter is at: %d \r\n", readMemory.value);
            counter = readMemory.value;
        } else {
            printf("Uninitialized, setting up first time");
            packed_A newmemory;
            newmemory.magic = MAGIC_VALUE;
            newmemory.value = 0;
            counter = 0;
            flash_device.erase(address, flash_device.get_sector_size(address));
            flash_device.program(&newmemory, address, sizeof(newmemory));
            printf("Flashed");
        }
    }
    while(1) {
        if (button == 0) { // Button is pressed
            counter++;
            packed_A newmemory;
            newmemory.magic = MAGIC_VALUE;
            newmemory.value = counter;
             flash_device.erase(address, flash_device.get_sector_size(address));
            flash_device.program(&newmemory, address, sizeof(newmemory));
            printf("Counter: %d \r\n", counter);
            wait(0.2); //Waiting to make sure that holding down the button doesn't make the machine go crazy
        }
    }
}