/**
 * Copyright (c) 2015 The Positive Charge, LLC for Supervision, LLC
 * @file   SV_USBConfig.h
 * @date   June 2015
 * @brief  Freescale KL25Z firmware for USB-RFID adapter
 *
 * Includes USB Config Descriptor strings in UNICODE
 *   iManufacturer = "Supervision"
 *   iSerial       = "SV1"
 *   iProduct      = "USB-RFID Adapter"
 *
 * The Serial Number string will be reassigned to the 80-bit KL25Z unique ID
 *
 */
#ifndef SV_USBConfig_h
#define SV_USBConfig_h

// VID and PID 
#define SV_VID      0x0425
#define SV_PID      0x0415


// Strings
#define SV_MFG_CNT  24      // String length in UNICODE plus two bytes for the count (this value) and string type
#define SV_MFG      'S',0,'u',0,'p',0,'e',0,'r',0,'v',0,'i',0,'s',0,'i',0,'o',0,'n',0,
#define SV_SER_CNT  8
#define SV_SER      'S',0,'V',0,'1',0,
#define SV_DES_CNT  34
#define SV_DES      'U',0,'S',0,'B',0,'-',0,'R',0,'F',0,'I',0,'D',0,' ',0,'A',0,'d',0,'a',0,'p',0,'t',0,'e',0,'r',0,

#endif
// EOF SV_USBConfig.h
