/**
 * Copyright (c) 2015 The Positive Charge, LLC for Supervision, LLC
 * @file   ProxInit.h
 * @date   June 2015
 * @brief  Freescale KL25Z firmware for USB-RFID adapter
 *
 *  Contains default values for the ST VL6180X proximity sensor
 *  See:
 *  http://www.st.com/st-web-ui/static/active/en/resource/technical/document/application_note/DM00122600.pdf
 */
 
 char proxinit[] = {
     // Mandatory : private registers
     // lochi loclo value == reg addr high byte, reg addr low byte, reg value
        0x02, 0x07, 0x01,
        0x02, 0x08, 0x01,
        0x00, 0x96, 0x00,
        0x00, 0x97, 0xfd,
        0x00, 0xe3, 0x00,
        0x00, 0xe4, 0x04,
        0x00, 0xe5, 0x02,
        0x00, 0xe6, 0x01,
        0x00, 0xe7, 0x03,
        0x00, 0xf5, 0x02,
        0x00, 0xd9, 0x05,
        0x00, 0xdb, 0xce,
        0x00, 0xdc, 0x03,
        0x00, 0xdd, 0xf8,
        0x00, 0x9f, 0x00,
        0x00, 0xa3, 0x3c,
        0x00, 0xb7, 0x00,
        0x00, 0xbb, 0x3c,
        0x00, 0xb2, 0x09,
        0x00, 0xca, 0x09,
        0x01, 0x98, 0x01,
        0x01, 0xb0, 0x17,
        0x01, 0xad, 0x00,
        0x00, 0xff, 0x05,
        0x01, 0x00, 0x05,
        0x01, 0x99, 0x05,
        0x01, 0xa6, 0x1b,
        0x01, 0xac, 0x3e,
        0x01, 0xa7, 0x1f,
        0x00, 0x30, 0x00,
        
// Recommended : Public registers - See data sheet for more detail
        0x00, 0x11, 0x10,   // Enables polling for ‘New Sample ready’ when measurement completes
        0x01, 0x0a, 0x30,   // Set the averaging sample period (compromise between lower noise and increased execution time)
        0x00, 0x3f, 0x46,   // Sets the light and dark gain (upper nibble). Dark gain should not be changed.
        0x00, 0x31, 0xFF,   // sets the # of range measurements after which auto calibration of system is performed
        0x00, 0x40, 0x63,   // Set ALS integration time to 100ms
        0x00, 0x2e, 0x01,   // perform a single temperature calibration of the ranging sensor

// Optional: Public registers - See data sheet for more detail
        0x00, 0x1b, 0x09,   // Set default ranging inter-measurement period to 100ms
        0x00, 0x3e, 0x31,   // Set default ALS inter-measurement period to 500ms
//        0x00, 0x14, 0x24,   // Configures interrupt on ‘New Sample Ready threshold event’ //Set in SV-specific section below

/* The following values are only shown here for reference.  
 * These will ultimately be programmed into EEPROM by the factory test program.
// Supervision-specific requirements
        0x00, 0x11, 0x10,   // Set interrupt output as GPIO1, active low
        0x00, 0x1a, 0x64,   // Set low measurement threshold to 100mm
        0x00, 0x14, 0x01,   // Interrupt trigger on below measurement threshold
        0x00, 0x1e, 0x00,   // Glass crosstalk compensation (high byte)
        0x00, 0x1f, 0x44,   // Glass crosstalk compensation (low byte) 0.5388 ==> 0x0044 in 9.7 format
        0x00, 0x24, 0x08,   // Glass compensation offset
        0x00, 0x26, 0x0a,   // Low threshold ignore = comp * 1.2 = 9.6 ==> 10
*/
        };
 // EOF ProxInit.h
 