/*Air mouse using USB HID with Sensitivity adjustment.
4 values of sensitivity and option is taken from user through serial.*/

#include "mbed.h"
#include "USBMouse.h"
#include "MMA8451Q.h"
#include "TSISensor.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS); 
Serial pc(USBTX, USBRX); // tx, rx
TSISensor tsi;
USBMouse mouse;

int main()
{
    int16_t x = 0;
    int16_t y = 0;
    int s=10;
    char c='b';
    pc.printf("Enter level of sensitivity (a-d) : "); 
        
    while(1)
    {
        if (pc.readable())
        {
            c = pc.getc();
    
            switch(c)
            {
                case 'a': s = 20; break;
                case 'b': s = 40; break;
                case 'c': s = 80; break;
                case 'd': s = 100; break;
                default: s = 10; break;
            }
        }
        
        x = -s*(acc.getAccX());   
        y = s*acc.getAccY();
        
        mouse.move(x,y);
        
        //left click
        if (tsi.readPercentage() > 0.7)
        {
            mouse.press(MOUSE_LEFT);
        }
        else
        {
            mouse.release(MOUSE_LEFT);
        }
        
        //right click
        if (tsi.readPercentage() < 0.3 && tsi.readPercentage() > 0)
        {
            mouse.press(MOUSE_RIGHT);
        }
        else
        {
            mouse.release(MOUSE_RIGHT);
        }
    }
}
