#include "mbed.h"
#include "nRF24L01P.h"
#include "ESP8266.h"

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // MOSI, MISO, SCK, CSN, CE, IRQ
DigitalOut GreenLED(LED2);


ESP8266 wifi(PTE0, PTE1, 115200);

//buffers for wifi library
char resp[1000];
char http_cmd[300], comm[300];

int timeout = 1000;

//SSID and password for connection
#define SSID "TAT"
#define PASS "tatuniversity"

//Remote IP
#define IP "184.106.153.149" //  52.202.122.57
//global variable
//float potvalue = 0;
//float litvalue = 0;
int abt;
//Update key for thingspeak
char* Update_Key = "P2GMSKA9NY7KV0LW";




void wifi_initialize(void)
{
    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.Reset();

    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.RcvReply(resp, 5000))
        pc.printf("%s",resp);
    else
        pc.printf("No response");


    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");


    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while connecting to network \r\n");


    pc.printf("******** Getting IP and MAC of module ********\r\n");
    wifi.GetIP(resp);
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while getting IP \r\n");


    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);


    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
}





void wifi_send(void)
{
    pc.printf("******** Starting TCP connection on IP and port ********\r\n");
    wifi.startTCPConn(IP,80);    //cipstart
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while starting TCP connection \r\n");
    wait(1);

    //create link
    sprintf(http_cmd,"/update?api_key=%s&field1=%d",Update_Key,abt);

    pc.printf(http_cmd);

    pc.printf("******** Sending URL to wifi ********\r\n");
    wifi.sendURL(http_cmd, comm);   //cipsend and get command
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while sending URL \r\n");
}





int main()
{
     wifi_initialize();
    char RxDataCnt;
    char temp;
    char count[1];
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2400);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    RxDataCnt = 2;
    my_nrf24l01p.setTransferSize( RxDataCnt );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    while (1) {
        if ( my_nrf24l01p.readable() ) 
        {
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, count, RxDataCnt );
            abt=count[0];
            pc.printf( "%d\r\n",count[0]);
           wifi_send();
            wait(24);
           
        }
       //
//     wait(20);

    }
}
