#include "mbed.h"
#include "MMA8451Q.h"
#include "ESP8266.h"

Serial pc(USBTX,USBRX);

#if   defined (TARGET_KL25Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)


//wifi UART port and baud rate
ESP8266 wifi(PTE0, PTE1, 115200);

//buffers for wifi library
char resp[1000];
char http_cmd[300], comm[300];

int timeout = 3000; //timeout for wifi commands

//SSID and password for connection
#define SSID "Karkhana"
#define PASS "Karkhana2018"

//Remote IP
#define IP "184.106.153.149" //  52.54.134.167


char* Update_Key = "VQG4N1PCODU1C4IU";

float x, y, z;

//Wifi init function
void wifi_initialize(void)
{

    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.Reset();

    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.RcvReply(resp, 5000))
        pc.printf("%s",resp);
    else
        pc.printf("No response");


    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");


    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while connecting to network \r\n");


    pc.printf("******** Getting IP and MAC of module ********\r\n");
    wifi.GetIP(resp);
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while getting IP \r\n");


    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);


    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
}


void wifi_send(void)
{
    pc.printf("******** Starting TCP connection on IP and port ********\r\n");
    wifi.startTCPConn(IP,80);    //cipstart
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while starting TCP connection \r\n");
    wait(1);

    //create link
    sprintf(http_cmd,"/update?api_key=%s&field1=%f&field2=%f&field3=%f",Update_Key,x,y,z);

    pc.printf(http_cmd);

    pc.printf("******** Sending URL to wifi ********\r\n");
    wifi.sendURL(http_cmd, comm);   //cipsend and get command
    if (wifi.RcvReply(resp, timeout))
        pc.printf("%s",resp);
    else
        pc.printf("No response while sending URL \r\n");
}


int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);

    wifi_initialize();

    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        
        x = abs(acc.getAccX()) * 255;
        y = abs(acc.getAccY()) * 255;
        z = abs(acc.getAccZ()) * 255;
        wifi_send();
        wait(3);
        printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
    }
}
