#include "mbed.h"


//Global objects
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
Ticker t;

//Integer state of the LED
//static makes it visible only within main.cpp
static int state = 0;

//Function prototype
void doISR();

int main() {
   
   //Initialise
   pc.baud(115200);
   t.attach(&doISR, 2);
   myled = 0;
    
    //Main loop
    while(1) {
        
        //Go to sleep and wait for an ISR to wake
        sleep();    //At is says
        
        //At this point, the ISR has run
        
        //Update LED
        myled = state;
        
        //Echo to terminal
        if (state == 0) {
            pc.printf("LED OFF\n");
        } else {
            pc.printf("LED ON\n");   
        }
    }
}

//Note - the ISR is short, and does NOT call functions
//such as printf (it's actually unsafe to do so)
//Always check a function is "reentrant" before calling it
void doISR() {
    //Toggle 0 to 1, or 1 to 0
    state ^= 1;      
}