#include "mbed.h"
#include "rtos.h"

unsigned int delayms = 1000;

void print_char(char c = '*')
{
    printf("%c", c);
    fflush(stdout);
}

DigitalOut led1(LED1);

void print_thread(void const *argument)
{
    while (true) {
        Thread::wait(delayms);
        led1 = !led1;
    }
}

void read_keyboard(void const *argument)
{
    char c;
    while (true) {
        
        c = getchar();
        printf("\t%X\n", c);
    }
}


int main()
{
    printf("\n\n*** RTOS basic example ***\n");
    Thread t1(print_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE);
    Thread t2(read_keyboard);
    
    //Sleep the main thread
    Thread::wait(osWaitForever);
}
