// Suggested partial solution for sending of amessage typed into termianl
// by flashing the morse code for each letter in the message on LED
// attached to D7 pin
// Data entry and debug messages on PC terminal
//
// Chris Tipney September 2017 for module ELEC143
//
// Current limitations
// (1) Only first 4 alpha characters and no numbers
// (2) No warning if message length exceeded
// (3) No trapping of non alpha characters (e.g. space or tab)
//  
// Suggested improvements:
// Add rest of alphabet and numbers - rest of ASCII table must be trapped
// Put suitable areas of code into functions

#include "mbed.h"

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalOut myled(D7);

const int maxMessageLength = 20;        // max message length
char message[maxMessageLength];   // Holds the message to be transmitted

// array of strings to hold the morse codes (only A to D so far)
// O = DOT (sound is DIT)
// A = DASH (sound is DAA);
// S = SPACE after a letter
char codes[][6] = { "OAS",   // DIT DAA = A
                    "AOOOS", // DAA DIT DIT = B
                    "AOAOS", // DAA DIT DAA DIT = C
                    "AOOS"   // DAA DIT DIT = D
                    };

int main()
{
    int position = 0;
    
    pc.printf("Morse message start...\n\r");
    
    while(1) {
        // diaplay opening message and get message
        printf("\n\r");
        pc.printf("Please enter your message and press enter\n\r");
        scanf("%s", message);
        pc.printf("Message is %s\n\r", message);
        
        for (int i = 0; i < strlen(message); i++)
        {
            if ((message[i] > 64) && (message[i] < 91))     // upper case letter
            {
                position =  message[i] - 65;
            }
            else if ((message[i] > 96) && (message[i] < 123))   // lower case letter
            {
                position =  message[i] - 97;
            }
            
            printf("%d:%c:%d:%d ", i, message[i], message[i], position);
            printf("\n\r");
            printf("%d %s ", position, codes[position]);
            printf("\n\r");
            printf("Letter is %c ", message[i]);
            for (int j=0; j < strlen(codes[position]); j++)
            {
                if (codes[position][j] == 'O') 
                {
                    printf("DIT ");
                    myled = 1;
                    wait(0.15);
                    myled = 0;
                    wait(0.15);
                }
                   
                if (codes[position][j] == 'A') 
                {
                    printf("DAA ");
                    myled = 1;
                    wait(0.45);
                    myled = 0;
                    wait(0.15);
                }
                
                if (codes[position][j] == 'S')
                {
                    printf("<SPACE> ");
                    wait(0.30);
                }
                //printf("%c ", codes[position][j]);
            }
            printf("\n\r");
        }
        
    }
}
