// Elec143 Morsecode labwork
//
// Suggested solution using functions
// Chris Tipney September 2017
//
// Morse code
// dot = 150 ms
// dash = 450 ms
// symbol space = 150 ms
// letter space = 450 ms
// word space = 900 ms
//
// Note
// Every symbol is followed by at least 150 ms
// only the space beyond that varies according
// to context

#include "mbed.h"

// function prototypes
void sierra(int r);     // output the pattern for the letter 'S' repeat according to value of r
void oscar(int r);      // output the pattern for the letter 'O' repeat according to value of r
void dot(int r);        // output a short flash followed by 150 ms space repeat according to value of r
void dash(int r);       // output a long flash followed by 150 ms space repeat according to value of r
void letterspace();     // output 300 ms space to make up the rest of the letter space 450 ms
void wordspace();       // output 750 ms space to make up the rest of the word space 900 ms

// led attached to port D7
DigitalOut myled(D7);

int main() 
{
    while(1)                // loop forever
    {
        sierra(1);          // S
        oscar(1);           // O
        sierra(1);          // S
        wordspace();
    }
}

// function implementations

void sierra(int rep)
{
    for (int i = 0; i < rep; i++)
    {
        dot(3);
        letterspace();
    }
}

void oscar(int rep)
{
        for (int i = 0; i < rep; i++)
    {
        dash(3);
        letterspace();
    }
}


void dot(int rep)
{
    for (int i = 0; i < rep; i++)
    {
        myled = 1;
        wait(0.150);
        myled = 0;
        wait(0.150);
    }
}

void dash(int rep)
{
    for (int i = 0; i < rep; i++)
    {
        myled = 1;
        wait(0.450);
        myled = 0;
        wait(0.150);
    }
}

void wordspace()
{
    wait(.750);
}

void letterspace()
{
    wait(.300);
}
