#include "mbed.h"
 
//This class manages an Interrupt in and LED output
//It automatically manages the switch-debounce using edge detection and timers
class SwitchManager {
private:
// enum State {LOW, LOW_DEBOUNCE, HIGH, HIGH_DEBOUNCE};  
    InterruptIn& switchInterrupt;
    DigitalOut& led;
    Timeout t;
    
    void waitForRising() {
        //Turn off interrupt
        switchInterrupt.rise(NULL);
        //Turn on timer
        t.attach(callback(this, &SwitchManager::waitForStabilityRising), 0.2);
    }
    
    void waitForStabilityRising() {
        //Look for falling edge
        switchInterrupt.fall(callback(this, &SwitchManager::waitForFalling));
    }
    
    void waitForFalling() {
        led = !led;
        switchInterrupt.fall(NULL);
        t.attach(callback(this, &SwitchManager::waitForStabilityFalling), 0.2);
    }
    
    void waitForStabilityFalling() {
        //Look for rising edge
        switchInterrupt.rise(callback(this, &SwitchManager::waitForRising));
    }
    
public:
    SwitchManager(InterruptIn& intIn, DigitalOut& gpio) : switchInterrupt(intIn), led(gpio) {
        //Listen for rising edge
        switchInterrupt.rise(callback(this, &SwitchManager::waitForRising));
    }
    ~SwitchManager() {
        //Turn off LED and shut off any ISRs
        led = 0;
        switchInterrupt.rise(NULL);
        switchInterrupt.fall(NULL);
        t.detach();
    }
};