#include "mbed.h"
#include "SwitchManager.hpp"
 
#define N 1000000
#define RELEASED 0
#define PRESSED  1
 
//Function prototypes
void isr1();
void isr2();
void isrTick();
 
//Hardware objects
DigitalOut red_led(PE_15);     //CountUp is in its critical section
DigitalOut yellow_led(PB_10);  //CountDown is in its critical section
DigitalOut green_led(PB_11);   //counter != 0
DigitalOut onboardLED(LED1);
 
InterruptIn sw1(PE_12);
InterruptIn sw2(PE_14);
Ticker yellowTick;
 
void toggleYellowISR() {
    yellow_led = !yellow_led;    
}
    
int main() {
    
    //Light up
    red_led    = 1;
    yellow_led = 1;
    green_led  = 1;
    onboardLED = 0;
 
    //Interrupt controlled red led using sw1
    SwitchManager sm1(sw1, red_led);
 
    //Interrupt controlled red led using sw2    
    SwitchManager sm2(sw2, green_led);    
    
    //Simple ticker
    yellowTick.attach(&toggleYellowISR, 0.5);
    
    //Now loop forever
    while(1) { 
        sleep();
    };
}
 
 