#include "mbed.h"

class SWPoll {
    private:
    enum State {LOW, LOW_DEBOUNCE, HIGH,HIGH_DEBOUNCE};
    State state;
    DigitalIn& sw;
    DigitalOut& led;
    Timer t; 

    public:
    //Constructor
    SWPoll(DigitalIn& gpioIn,DigitalOut& gpioOut) : sw(gpioIn),led(gpioOut)
    {
        state = LOW;
        t.reset();
        led = 0;
    }
    //Deconstructor
    ~SWPoll(){
        //Shut Down
        t.stop();
        t.reset();
        led = 0;
    }
    // API - poll the switches
    // Use of a Timer to manage switch bounce
    void poll(){
        switch (state)
        {
        // waiting for switch to rise
        case LOW:
            if (sw == 1){
                state = LOW_DEBOUNCE;
                t.reset();
                t.start();
            }
            break;
        case LOW_DEBOUNCE:
            if (t.read_ms() >= 200){
                state = HIGH;
                t.stop();
                t.reset();
            }
            break;
        case HIGH:
            if (sw == 0) {
                led = !led;
                state = HIGH_DEBOUNCE;
                t.reset();
                t.start();
            }
            break;
        case HIGH_DEBOUNCE:
            if (t.read_ms() >= 200) {
                state = LOW;
                t.stop();
                t.reset();
            }
            break;
        default:
            t.stop();
            t.reset();
            state = LOW;
            break;
        } //end switch
        //This is a Mealy Machine - so no output logic follows
                
    }   
};
