#include "mbed.h"
#include "swpol.hpp"

DigitalOut led1(LED1);

DigitalOut red_led(PE_15);
DigitalOut yellow_led(PB_10);
DigitalOut green_led(PB_11);
DigitalIn sw1(PE_12);
DigitalIn sw2(PE_14);

SWPoll switch1(sw1, red_led);
SWPoll switch2(sw2, green_led);

Timer t;

// main() runs in its own thread in the OS
int main() {
    t.start();
    while(1) {
        if (t.read_ms() >= 500) {
            yellow_led = !yellow_led;
            t.reset();
        }
        switch1.poll();
        switch2.poll();
    };
}

