#ifndef __BLE_BUTTON_SERVICE_H__
#define __BLE_BUTTON_SERVICE_H__

class StepCounterService
{
public:
    const static uint16_t STEPCOUNTER_SERVICE_UUID              = 0xA000;
    const static uint16_t STEPCOUNTER_STATE_CHARACTERISTIC_UUID = 0xA001;

    StepCounterService(BLEDevice &_ble, bool buttonPressedInitial) :
        ble(_ble), StepCounterState(STEPCOUNTER_STATE_CHARACTERISTIC_UUID, &buttonPressedInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY) {
        GattCharacteristic *characteristics[] = {&StepCounterState};
        GattService         StepCounterService(StepCounterService::STEPCOUNTER_SERVICE_UUID, characteristics, sizeof(characteristics) / sizeof(GattCharacteristic *));
        ble.addService(StepCounterService);
    }

    void updateStepCounterState(int newState) {
        ble.updateCharacteristicValue(StepCounterState.getValueHandle(), (uint8_t *)&newState, sizeof(bool));
    }

private:
    BLEDevice                        &ble;
    ReadOnlyGattCharacteristic<bool>  StepCounterState;
};

class ButtonServiceB
{
public:
    const static uint16_t BUTTON_SERVICE_UUID              = 0xB000;
    const static uint16_t BUTTON_STATE_CHARACTERISTIC_UUID = 0xB001;
    const static uint16_t READWRITE_CHARACTERISTIC_UUID = 0xB002;

    ButtonServiceB(BLEDevice &_ble, bool buttonPressedInitial) :
        ble(_ble),
        buttonState(BUTTON_STATE_CHARACTERISTIC_UUID, &buttonPressedInitial, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        readWrite(READWRITE_CHARACTERISTIC_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ)  {
            
        GattCharacteristic *charTable[] = {&buttonState, &readWrite};
        GattService         buttonService(ButtonServiceB::BUTTON_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(buttonService);
    }

    void updateButtonState(int newState) {
        ble.updateCharacteristicValue(buttonState.getValueHandle(), (uint8_t *)&newState, sizeof(bool));
    }

private:
    BLEDevice                        &ble;
    ReadOnlyGattCharacteristic<bool>  buttonState;
    ReadWriteGattCharacteristic<uint8_t>  readWrite;
};

#endif /* #ifndef __BLE_BUTTON_SERVICE_H__ */
