#include "mbed.h"
#include <string>
using namespace std;

DigitalOut tx(D15);

Serial pc(USBTX, USBRX); // tx, rx
const int PPM = 4;
const int PACKET_LENGTH = 98;
unsigned int PULSE_LENGTH = 0;

//Function Prototypes
void blink_packet(char* buffer, int len);
void blink_char(char c);
void blink(int data);


/*Function: blink_packet:
    Preconditions: 
        len is index of last filled character in buffer
    Postconditions:
        transmits the packet buffer
*/
void blink_packet(char* buffer, int len)
{   
    //Encodes and transmits each character
    for (int i=0; i < len; i++) {
        blink_char(buffer[i]);
    }
    
    //Signifies end of packet
    tx = 1;
    wait_us(PULSE_LENGTH*(PPM+1));
    tx = 0;
}


/*Function: blink_char:
    Postconditions:
        transmits the char c via DPPM 4
*/
void blink_char(char c) {
    printf("%d", c);
    printf("%c", '\r');
    printf("%c", '\n');
    for (int i=3; i>=0; i--) {
        blink((c & (3 << i*2)) >> i*2);
    } 
}


/*Function: blink_packet:
    Preconditions: 
        data < DPPM used
    Postconditions:
        pulses the light to transmit data
*/
void blink(int data) {
    printf("%d", data);
    printf("%c", '\r');
    printf("%c", '\n');
    //Time on = PULSE_LENGTH
    tx = 1;
    wait_us(PULSE_LENGTH);
    
    //Time off = PULSE_LENGTH*(data value)
    //  For example, a 01 transmitted would have a difference between pulses of 2 PULSE_LENGTH
    tx = 0;
    wait_us(PULSE_LENGTH*(data+1));
    tx = 1;
} 

char checksum(char* buffer, int len)
{
    char sum = 0;
    for(int i = 0; i < len; i++) sum ^= buffer[i];
    return sum;
}

//http://stackoverflow.com/questions/8845178/c-programming-tcp-checksum
char checkSum(char *buffer, int size)
{
    unsigned long cksum=0;
    while(size)
    {
        cksum+=*buffer++;
        size--;
    }

    cksum = (cksum >> 16) + (cksum & 0xffff);
    cksum += (cksum >>16);
    return (char)(~cksum);
}

int main()
{
    pc.printf("3 CM Link Board - Transmit\r\n");
    pc.printf("Enter pulse length in microseconds (10e-6), enter for 1000\r\n");
    while(1) {
        char d = pc.getc();
        if(d != '\n') {
            PULSE_LENGTH = PULSE_LENGTH*10 + (d-'0'); 
        }
        else {
            if (PULSE_LENGTH == 0) PULSE_LENGTH = 1000;
            pc.printf("Pulse length is "); 
            pc.printf("%d", PULSE_LENGTH);
            pc.printf("\r\n");
            break;
        }
    }
    
    //Packet
    char buffer[PACKET_LENGTH + 2];
    int idx = 0;
    while(1) {
        char a = pc.getc();
        
        //Fills buffer then transmits  
        if (a == '~') {
            tx = tx ^ 1;
            while (pc.getc() != '~');
        }
        else if(a != '\n' && idx < PACKET_LENGTH){
            buffer[idx] = a;
            idx++;
        }
        else {
            //Adds ending characters
            // No need to add line ending characters -BZ
//            buffer[idx] = '\r';
//            idx++;
//            buffer[idx] = '\n';
//            idx++;
            // add the checksums
            char cksum2 = checkSum(buffer, PACKET_LENGTH);
            buffer[idx] = checksum(buffer, idx);
            idx++;
            buffer[idx] = cksum2;
            //Transmits packet
            blink_packet(buffer, idx);
            idx = 0;
        }
    }
}