#include "mbed.h"
#include "rtos.h"
#include "Servo.h"
#include "C12832.h"
#include <math.h>
#include <string>

#define Cos(a) cos(PI/180*(a))
#define Sin(a) sin(PI/180*(a))
#define PI 3.1415926

class nervousPuppy{
    public:

        nervousPuppy();
        
        bool isLonely();
        bool isScared();
        bool shutdown();
        
        void detectPlayer();
        float getPlayerDistance();
        void setPlayerDistance(float dist);
        
        float calculateAngle(string issue);
        void changePosition(string servo,float angle); 
        
    private:
        
        Mutex lockForDistance; //Not sure why needed
        float playerDistance, playerError;
        bool scared, lonely;
        const float LONELY = 22.0f; //Placeholder number
        const float SCARED = 24.0f; //Placeholder number
        const float RADIUS = 1.75f; //Placeholder number
        const float SHUTDOWN = 0.0f; //Placeholder number
        const float PULSE_RATE = 10; //Placeholder number - Pulses per second
        const float SERVO_TILT_LIMIT = 45; //Placeholder number - max angle servo can tilt by
        const float SERVO_ROTATE_LIMIT = 45; //Placeholder number - max angle servo can rotate by
};