#include "mbed.h"


// this is just initialized here ... move this to a .h file when finished
class Shape
{
public:
    Shape(int len); //this is used to init a square
    Shape(int len, int bre);    //this is used to init a rectangle
    int area(); // this function get me the area
    int perimeter();    //this function gets me the perimeter
    void printInfo();    //this function get me the info on the object


    int _len;
    int _bre;
};


//implementing the Shape constructor & functions here

//this is for square
Shape::Shape(int len)
{
    _len = len;
    _bre = -1;
}

//this is for a rectangle
Shape::Shape(int len, int bre)
{
    _len = len;
    _bre = bre;
}

int Shape::area()
{
    int area_val;

    if(_bre == -1) {
        area_val = _len * _len;
    } else {
        area_val = _len * _bre;
    }
    return area_val;
}

int Shape::perimeter()
{
    int peri_val;
    if(_bre == -1) {
        peri_val = 4 * _len;
    } else {
        peri_val = 2 * (_len + _bre);
    }
    return peri_val;

}

void Shape::printInfo()
{
    if(_bre == -1) {
        //printed here
        printf(" I'm a Square\n");
        printf("AREA: %d PERIMETER: %d \n", area(), perimeter());
    } else {
        printf(" I'm a Rectangle\n");
        printf("AREA: %d PERIMETER: %d \n", area(), perimeter());
    }
}

int main()
{
    Shape mySquare(30);
    Shape rect(52, 90);
    
    mySquare.printInfo();
    rect.printInfo();


    while(1) {
    }
}
