#include "mbed.h"
#include "WiflyInterface.h"
#include "NTPClient.h"

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/

WiflyInterface wifly(p9, p10, p30, p29, "new_frontiers", "asd", NONE);
NTPClient ntp;

int main() 
{
    wifly.init(); //Use DHCP

    while (!wifly.connect()); // join the network
        printf("IP Address is %s\n\r", wifly.getIPAddress());
   
    printf("Trying to update time...\r\n");
    if (ntp.setTime("0.pool.ntp.org") == 0)
    {
      printf("Set time successfully\r\n");
      time_t ctTime;
      ctTime = time(NULL);
      printf("Time is set to (UTC): %s\r\n", ctime(&ctTime));
    }
    else
    {
      printf("Error\r\n");
    } 
   
    wifly.disconnect();  

    while(1) {
    }
}