#include "mbed.h"
 
Ticker flipper;
DigitalOut led1(LED1);
DigitalOut led2(LED4);
InterruptIn button(p14);


void flip() {
    led2 = !led2;
}
 
void press(){
    flipper.detach();
    flipper.attach(&flip, 0.3); 
}

void release(){
    flipper.detach();
    flipper.attach(&flip, 2.0); 
}

int main() {
    led2 = 1;
    wait(1);
    flipper.attach(&flip, 2.0); // the address of the function to be attached (flip) and the interval (2 seconds)
    button.rise(&press);
    button.fall(&release);
    
 
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        led1 = !led1;
        wait(2);
    }
}
