// Tested: NUCLE-L476RG

#include "mbed.h"

// crea oggetti Button, LED e serialPC  
DigitalIn myButton(USER_BUTTON);
DigitalOut myLed(LED1);
DigitalIn InMIMA(PA_0); //PC_1; PB_0; PA_1; PA_0
DigitalOut OutSC(PC_0); 
DigitalIn InSC(PA_10); 
DigitalOut OutMIMA(PA_9); //PB_3; PB_6; PC_7; PA_9 


Serial pc(USBTX, USBRX, 921600); 


/********/
/* MAIN */
/********/
int main() 
{
    // messaggio di benvenuto
    pc.printf("\r\nHello World \r\n");
    myLed = 1; // Accendi LED
    wait_ms(1000);
    myLed = 0; // Accendi LED
    wait_ms(1000);

    
    //imposta il funzionamento del pulsante come "PullDown": Aperto = '0'. L'altra modalità di funzinamento è PullUp
    myButton.mode(PullUp);
    InMIMA.mode(PullUp);
    InSC.mode(PullUp);
  
    // POLLING: replica sul LED myLED lo stato del pulsante myButton
    while(true) 
    {
        //+++++ INIZIO Comunicazione da STM32 verso MIMA ++++++++++++++
        OutSC=myButton;
        if (InMIMA == 0) 
        {
            // Button is pressed
            myLed = 1; // Accendi LED
            pc.printf("InMIMA = 0 \r\n");
        }
        else 
        {
            // Button i released
            myLed = 0; // Spegni LED
            pc.printf("InMIMA = 1 \r\n");
        }
        //+++++ FINE Comunicazione da STM32 verso MIMA ++++++++++++++        
        
        //+++++ INIZIO Comunicazione da S/C verso STM32 ++++++++++++++
        OutMIMA=myButton;
        if (InSC == 0) 
        {
            // Button is pressed
            myLed = 1; // Accendi LED
            pc.printf("InSC = 0 \r\n");
        }
        else 
        {
            // Button i released
            myLed = 0; // Spegni LED
            pc.printf("InSC = 1 \r\n");
        }
        //+++++ FINE Comunicazione da S/C verso STM32 ++++++++++++++
        
        pc.printf("\r\n"); // per facilità di lettura
        wait_ms(200);
        
    }
    
 }