#include "mbed.h"
#include<stdlib.h>

// dimensione massima del pacchetto ricevuto su seriale
#define PACKETDIM   512


// Definizione periferica USB seriale del PC
Serial pc(USBTX, USBRX, 921600); // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// Definizione periferica seriale del Modulo Seriale HC05
Serial mySerial(PA_9, PA_10, 115200); //Tx, Rx, bps


// User Button, LED  
DigitalIn myButton(USER_BUTTON); // pulsante Blu sulla scheda. Associato a PC_13
DigitalOut myLed(LED2); // LED verde sulla scheda. Associato a PA_5



// array per la ricezione dei messaggi da Seriale
volatile char caRxPacket[PACKETDIM]; 

// contatore e indice di caratteri ricevuti da Seriale
volatile char nRxCharCount; // Contatore dei caratteri ricevuti; Si aggiornerà modulo 256 a buffer circolare
volatile char nRxCharIndex; // Indice dell'array dei caratteri ricevuti e già visualizzati sui LED; Si aggiornerà modulo 256 a buffer circolare

/**********************************************/
//          IRQ associata a Rx da PC 
//**********************************************/
void pcRxInterrupt(void)
{
    // array per la ricezione dei messaggi da seriale
    char cReadChar; 
    
    // ricevi caratteri su seriale, se disponibili   
    while((pc.readable()))
    {
        // acquisice stringa in input e relativa dimensione
        cReadChar = pc.getc(); // read character from PC
        mySerial.putc(cReadChar); // Diagnostica: write char to Seriale
        pc.putc(cReadChar); // Diagnostica: write char to PC
        
        //pc.printf("W>: 0x%02x\n\r",cReadChar); // diagnostica
    }
}

//**********************************************/
//          IRQ associata a Rx da Seriale 
//**********************************************/
void SerialeRxInterrupt(void)
{
    
    // carattere ricevuto da Seriale
    char cReadChar; 
    
    while((mySerial.readable()))
    {
        // acquisice stringa in input e memorizza in array
        cReadChar = mySerial.getc(); // Read character
        nRxCharCount++; // incrementa il contatore dei caratteri ricevuti
        caRxPacket[nRxCharCount]=cReadChar;
        
        // visualizza l'ultimo carattere ricevuto
        pc.printf("> Rx: %c \r\n",cReadChar); // diagnostica
    }
 }

/**********/
/*  MAIN  */
/**********/
int main()
{
    // indice per i cicli
    int nIndex;
    
    // LED su scheda inizialmente spento
    myLed = 0;
    
    
    // messaggio di benvenuto
    pc.printf("\r\n*****  Hallo ***** \r\n");
     
    
    // inizializza contatore e indice di caratteri ricevuti
    nRxCharCount = 0;
    nRxCharIndex =0;
        
    // inizializza array di caratteri ricevuti
    for(nIndex=0; nIndex<PACKETDIM; nIndex++)
    {
        caRxPacket[nIndex]=0;
    }
    
    // Attiva la IRQ per la RX su seriale   
    mySerial.attach(&SerialeRxInterrupt,Serial::RxIrq); // // entra in questa routine quando riceve un carattere dalla seriale del Seriale
    pc.attach(&pcRxInterrupt,Serial::RxIrq); // entra in questa routine quando riceve un carattere dalla USB del PC
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ INIZIO Test +++++++++++++++++++++++++++++++
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
       
           
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ FINE Test +++++++++++++++++++++++++++++++++
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ INIZIO Ciclo Principale +++++++++++++++++++    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    while(true)
    {
        //++++++++++++++++++++++++++ INIZIO Se premuto il myButton effettua un test  +++++++++++++++++++++++++++++
        if(myButton == 0)
        {
            myLed =1;
        }
        else
        {
            myLed =0;
        }
        //++++++++++++++++++++++++++ FINE Se premuto il myButton effettua test +++++++++++++++++++++++++++++
   
    } //while(true) Ciclo principale
    
    //++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    //++++++++++++++ FINE Ciclo Principale  +++++++++++++++++++    
    //+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
} // main()
