#include "mbed.h"

#ifndef HEADER_FILE
#define HEADER_FILE

#define size 1

typedef struct Telecommand {
    char *ID;
    char *TAG;
    char *PAYLOAD;
    char LSB;
} Telecommand;

typedef struct Telemetry {
    char *ID;
    char *TAG;
    char *PAYLOAD;
    char LSB;
} Telemetry;

// Telecomandi
extern  Telecommand           cmd00[size]   = { {"00000", "00", "", '0'} };
extern  Telecommand       mima_mode[size]   = { {"00001", "00", "", '0'} };
extern  Telecommand           cmd02[size]   = { {"00010", "00", "", '0'} };
extern  Telecommand     ldth_on_off[size]   = { {"00011", "00", "", '0'} };
extern  Telecommand     irth_on_off[size]   = { {"00100", "00", "", '0'} };
extern  Telecommand          tlmode[size]   = { {"00101", "00", "", '0'} };
extern  Telecommand      start_stop[size]   = { {"00110", "00", "", '0'} };
extern  Telecommand   temp_sens_sel[size]   = { {"00111", "00", "", '0'} };
extern  Telecommand       tinitscan[size]   = { {"01000", "00", "", '0'} };
extern  Telecommand           nskip[size]   = { {"01001", "00", "", '0'} };
extern  Telecommand       cover_thr[size]   = { {"01010", "00", "", '0'} };
extern  Telecommand           cover[size]   = { {"01011", "00", "", '0'} };
extern  Telecommand      cal_on_off[size]   = { {"01100", "00", "", '0'} };
extern  Telecommand       ld_on_off[size]   = { {"01101", "00", "", '0'} };
extern  Telecommand     bbth_on_off[size]   = { {"01110", "00", "", '0'} };
extern  Telecommand           cmd15[size]   = { {"01111", "00", "", '0'} };
extern  Telecommand            locs[size]   = { {"10000", "00", "", '0'} };
extern  Telecommand            ldcs[size]   = { {"10001", "00", "", '0'} };
extern  Telecommand            ldts[size]   = { {"10010", "00", "", '0'} };
extern  Telecommand            irts[size]   = { {"10011", "00", "", '0'} };
extern  Telecommand            bbts[size]   = { {"10100", "00", "", '0'} };
extern  Telecommand             pga[size]   = { {"10101", "00", "", '0'} };
extern  Telecommand         pm_loop[size]   = { {"10110", "00", "", '0'} };
extern  Telecommand      pm_speed[2*size]   = { {"10111", "01", "", '0'}, {"10111", "10", "", '0'} };
extern  Telecommand              kp[size]   = { {"11000", "00", "", '0'} };
extern  Telecommand              ki[size]   = { {"11001", "00", "", '0'} };
extern  Telecommand              kd[size]   = { {"11010", "00", "", '0'} };
extern  Telecommand             att[size]   = { {"11011", "00", "", '0'} };
extern  Telecommand      n_sample[2*size]   = { {"11100", "01", "", '0'}, {"11100", "10", "", '0'} };
extern  Telecommand        int_samp[size]   = { {"11101", "00", "", '0'} };
extern  Telecommand           cmd31[size]   = { {"11110", "00", "", '0'} };
extern  Telecommand      mima_reset[size]   = { {"11111", "00", "", '0'} };

// Telemetrie
extern  Telemetry           irt1[2*size]   = { {"00000", "01", "", '0'}, {"00000", "10", "", '0'} };
extern  Telemetry           irt2[2*size]   = { {"00001", "01", "", '0'}, {"00001", "10", "", '0'} };
extern  Telemetry           ldt1[2*size]   = { {"00010", "01", "", '0'}, {"00010", "10", "", '0'} };
extern  Telemetry           ldt2[2*size]   = { {"00011", "01", "", '0'}, {"00011", "10", "", '0'} };
extern  Telemetry   mima_el_t1_2[2*size]   = { {"00100", "01", "", '0'}, {"00100", "10", "", '0'} };
extern  Telemetry       mima_el_t3[size]   = { {"00101", "01", "", '0'} };
extern  Telemetry     mima_ob_t1[2*size]   = { {"00110", "01", "", '0'}, {"00110", "10", "", '0'} };
extern  Telemetry     mima_ob_t2[2*size]   = { {"00111", "01", "", '0'}, {"00111", "10", "", '0'} };
extern  Telemetry           bbt1[2*size]   = { {"01000", "01", "", '0'}, {"01000", "10", "", '0'} };
extern  Telemetry           bbt2[2*size]   = { {"01001", "01", "", '0'}, {"01001", "10", "", '0'} };
extern  Telemetry          v15pn[2*size]   = { {"01010", "01", "", '0'}, {"01010", "10", "", '0'} };
extern  Telemetry           v5pn[2*size]   = { {"01011", "01", "", '0'}, {"01011", "10", "", '0'} };
extern  Telemetry               v3[size]   = { {"01100", "01", "", '0'} };
extern  Telemetry          vintp[2*size]   = { {"01101", "01", "", '0'}, {"01101", "10", "", '0'} };
extern  Telemetry         cali_v[2*size]   = { {"01110", "01", "", '0'}, {"01110", "10", "", '0'} };
extern  Telemetry            ldc[2*size]   = { {"01111", "01", "", '0'}, {"01111", "10", "", '0'} };
extern  Telemetry        ramp_hk[2*size]   = { {"10000", "01", "", '0'}, {"10000", "10", "", '0'} };
extern  Telemetry          ldcsr[2*size]   = { {"10001", "01", "", '0'}, {"10001", "10", "", '0'} };
extern  Telemetry           ldtr[2*size]   = { {"10010", "01", "", '0'}, {"10010", "10", "", '0'} };
extern  Telemetry            irt[2*size]   = { {"10011", "01", "", '0'}, {"10011", "10", "", '0'} };
extern  Telemetry            bbt[2*size]   = { {"10100", "01", "", '0'}, {"10100", "10", "", '0'} };
extern  Telemetry        pmspeed[2*size]   = { {"10101", "01", "", '0'}, {"10101", "10", "", '0'} };
extern  Telemetry        pmparam[2*size]   = { {"10110", "01", "", '0'}, {"10110", "10", "", '0'} };
extern  Telemetry     n_sample_r[2*size]   = { {"10111", "01", "", '0'}, {"10111", "10", "", '0'} };
extern  Telemetry            ipn[2*size]   = { {"11000", "01", "", '0'}, {"11000", "10", "", '0'} };
extern  Telemetry      mima_sts1[2*size]   = { {"11001", "01", "", '0'}, {"11001", "10", "", '0'} };
extern  Telemetry      mima_sts2[2*size]   = { {"11010", "01", "", '0'}, {"11010", "10", "", '0'} };
extern  Telemetry      mima_sts3[2*size]   = { {"11011", "01", "", '0'}, {"11011", "10", "", '0'} };
extern  Telemetry      mima_sts4[2*size]   = { {"11100", "01", "", '0'}, {"11100", "10", "", '0'} };
extern  Telemetry          techo[2*size]   = { {"11101", "01", "", '0'}, {"11101", "10", "", '0'} };

#endif