#include "mbed.h"

DigitalOut led(LED1);
DigitalOut Din(PB_9);
Serial pc(USBTX, USBRX, 9600);  // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// carattere in arrivo dal PC
volatile unsigned char cReadChar;


void RxInterrupt(void)
{
    // ricevi caratteri su seriale, se disponibili   
    while((pc.readable()))
    {
        // leggi carattere e riscrivi carattere su UART
        cReadChar = pc.getc();
        pc.printf("\r\nRx [CHAR]: %c\n\r",cReadChar);   
        pc.printf("Rx [HEX]: %#x\n\r", cReadChar);
        pc.printf("Rx [reverse BIN]: ");
        for(int i = 0; i< 8; i++)
            pc.printf("%d",((cReadChar>>i)&0x01));   
        pc.printf("\n\r");    
        
      
    }
}

//+++++++++
// MAIN
//+++++++++
int main() 
{
    pc.printf("\n\r*** Welcome TxRx ***\n\r");
    
    // definisci callback di IRQ
    pc.attach(&RxInterrupt,Serial::RxIrq);
    
    // ciclo main
    while(true)
    {
        led = !led; // Toggle LED
        wait_ms(500);
    }   
}