#include "mbed.h"

// dimensione del pacchetto di comunicazione tra PC e uC. esempio di 30 caratteri: 1/0 say goodbye to your sister
#define PACKETDIM 31

DigitalOut led(LED1);
DigitalOut Din(PB_9);
Serial pc(USBTX, USBRX, 9600);  // seriale di comunicazione con il PC. Associati a PA_11 e PA_12

// Definizione periferica seriale 
//Serial myBLE(PC_1, PC_0, 9600); //Tx, Rx, bps. per la configurazione bps = 38400. Di default HC05 comunica con bps = 9600

// indice per i cicli
int nIndex;

// indice dell'array caRxPacket[]
volatile int  nRxIndex;
// carattere in arrivo dal PC
volatile char caReadChar;

// pacchetto ricevuto dal PC
char caRxPacket[PACKETDIM];
int nRxPacketSize;

void RxInterrupt(void)
{
    // reset pacchetto ricevuto
    nIndex=0;
    for(nIndex=0;nIndex<PACKETDIM;nIndex++)
    {
        caRxPacket[nIndex]='\0';
    }
   
    // ricevi caratteri su seriale, se disponibili   
    while((pc.readable()))
    {
        pc.gets(caRxPacket,sizeof(caRxPacket));
        nRxPacketSize = strlen(caRxPacket);
        //pc.printf("*** pc.readable = %2d \n\r",nRxPacketSize); 
        //pc.scanf("%s", &caRxPacket);
        //+++pc.putc(pc.getc());             // read data from UART
        
    }
    //pc.printf("%s",caRxPacket); 
    pc.printf("\n\rYou also say goodbye to yours tk\n\r"); 
}

int main() 
{
    pc.printf("\n\r*** Welcome ***\n\r");
       
    pc.attach(&RxInterrupt,Serial::RxIrq);
    
    while(true)
    {
        led = !led; // Toggle LED
        wait_ms(500);
    }   
}